/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.service.validate;

import com.huawei.ism.base.sdk.util.ValidateUtil;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;
import java.util.Map;

public class StorageDiscParamValidator
implements IDisParamValidator {
    private static final Log logger = LogFactory.getInstance(StorageDiscParamValidator.class);
    private static final String ISM_STORAGE_SUB_TYPE = "ism.storage.manufacture.0huawei";
    private static final String ISM_STORAGE_DEVICE_TYPE = "ism.deviceType.storage.mainType";

    public String getValidatorKey() {
        return "ism.deviceType.storage.mainTypeism.storage.manufacture.0huawei";
    }

    public DiscParamVilidateResult validate(DiscoveryPolicy policy) {
        DiscParamVilidateResult result = new DiscParamVilidateResult();
        result.setResult(true);
        if (null == policy) {
            logger.error((Object)"Invalid parameter", 90160758784001L);
            result.setResult(false);
            result.setErrorCode(1073947393L);
            return result;
        }
        try {
            Map paramMap = policy.getParamMap();
            String name = (String)paramMap.get("name");
            name = DiscParamValidator.decodeByLength((String)name);
            String password = (String)paramMap.get("password");
            password = DiscParamValidator.decodeByLength((String)password);
            String restPort = (String)paramMap.get("port");
            this.validateUsername(name);
            this.validatePwd(password);
            this.validatePort(restPort);
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)("The errorCode is " + ex.getErrorCode()), 90160758784001L);
            result.setResult(false);
            result.setErrorCode(ex.getErrorCode());
        }
        return result;
    }

    private void validateUsername(String name) {
        if (null == name) {
            throw new LegoCheckedException(2099466L);
        }
        if (!ValidateUtil.checkLength((String)name, (int)1, (int)32)) {
            throw new LegoCheckedException(2099466L);
        }
    }

    private void validatePwd(String pwd) {
        if (null == pwd) {
            throw new LegoCheckedException(2099466L);
        }
        if (!ValidateUtil.checkLength((String)pwd, (int)1, (int)32)) {
            throw new LegoCheckedException(2099466L);
        }
    }

    private void validatePort(String port) {
        if (VerifyUtil.isEmpty((String)port)) {
            return;
        }
        long portVal = NumberUtil.parseLong((Object)port);
        if (!ValidateUtil.checkPort((long)portVal)) {
            throw new LegoCheckedException(2099466L);
        }
    }
}

