/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.handler;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class ArrayHostGroupHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this);

    @Override
    public void handle(Notification msg) {
        String deviceId = msg.getConnection().getArrayId();
        this.logger.info((Object)("-----> ArrayHostGroupHandler handle ... " + deviceId), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit storageUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)deviceId);
        if (null == storageUnit) {
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            ManagedObject entity = moDao.getMoByUuid(uuid, Boolean.valueOf(true));
            if (null != entity) {
                moDao.deleteMoWithoutMsg(entity.getMoId());
            }
        } else {
            ArrayHostGroup hostGroup = null;
            Collection<?> v1Objs = msg.getV1Object();
            Iterator<?> iterator = v1Objs.iterator();
            if (iterator.hasNext()) {
                Object v1 = iterator.next();
                ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
                if (null == transition) {
                    this.logger.error((Object)("transition is null, " + v1.getClass()));
                    throw new LegoCheckedException(0x200909L);
                }
                hostGroup = (ArrayHostGroup)transition.convertToV2(v1);
                this.logger.info((Object)("---> hostGroup : " + hostGroup), 90160777658372L);
            }
            if (null != hostGroup) {
                hostGroup.setParentMo((ManagedObject)storageUnit);
                hostGroup.setTopMoUuid(storageUnit.getTopMoUuid());
                moDao.saveOrUpdateMo(hostGroup);
                this.updateS2600HostOsInfo(moDao, storageUnit, hostGroup);
            }
        }
    }

    private void updateS2600HostOsInfo(IMoDao moDao, StorageUnit storageUnit, ArrayHostGroup hostGroup) {
        List arrayHosts;
        String subType = storageUnit.getSubType();
        if (null != subType && subType.indexOf("S2600(V100R002)") > -1 && null != hostGroup.getMoId() && !VerifyUtil.isEmpty((Collection)(arrayHosts = moDao.getAllSubMo(hostGroup.getMoId().longValue(), ArrayHost.class)))) {
            for (ArrayHost arrayHost : arrayHosts) {
                arrayHost.setOs(hostGroup.getOs());
                moDao.onlyUpdateWithoutMsg((ManagedObject)arrayHost);
            }
        }
    }

    @Override
    public String handleType() {
        return "ISM_ProtocolControllerGroup";
    }
}

