/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.handler;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ArrayDiscoverUtil;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.service.DefaultConvertor;
import com.huawei.ism.cbb.proxy.service.ITransition;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.entity.components.Initiator;
import com.huawei.ism.common.entity.components.Port;
import com.huawei.ism.common.entity.hosts.Host;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMObjectPath;

public class ArrayHostHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this);

    @Override
    public void handle(Notification msg) {
        String deviceId = msg.getConnection().getArrayId();
        this.logger.info((Object)("-----> ArrayHostHandler handle ... " + deviceId), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit storageUnit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)deviceId);
        if (null == storageUnit) {
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            ManagedObject entity = moDao.getMoByUuid(uuid, Boolean.valueOf(true));
            if (null != entity) {
                moDao.deleteMoWithoutMsg(entity.getMoId());
            }
        } else {
            ArrayHost host = null;
            Host v1Host = null;
            Collection<?> v1Objs = msg.getV1Object();
            Iterator<?> iterator = v1Objs.iterator();
            if (iterator.hasNext()) {
                Object v1 = iterator.next();
                ITransition transition = DefaultConvertor.getInstance().getTransitionByV1(v1.getClass());
                if (null == transition) {
                    this.logger.error((Object)("transition is null, " + v1.getClass()));
                    throw new LegoCheckedException(0x200909L);
                }
                if (v1 instanceof Host) {
                    v1Host = (Host)v1;
                }
                host = (ArrayHost)transition.convertToV2(v1);
                this.logger.info((Object)("---> host: " + host), 90160777658372L);
            }
            if (null != host) {
                ArrayHostGroup hostGroup = (ArrayHostGroup)moDao.getMo(ArrayHostGroup.class, "uuid", (Object)host.getHostGroupUuid());
                host.setParentMo((ManagedObject)hostGroup);
                host.setTopMoUuid(storageUnit.getTopMoUuid());
                if (VerifyUtil.isEmpty((String)host.getOs()) || "--".equals(host.getOs())) {
                    host.setOs(hostGroup.getOs());
                }
                moDao.saveOrUpdateMo((ManagedObject)host);
            }
            if (null != v1Host) {
                this.processInitiator(moDao, storageUnit, v1Host);
            }
        }
    }

    private void processInitiator(IMoDao moDao, StorageUnit array, Host v1Host) {
        ArrayList<com.huawei.ism.base.sdk.model.Initiator> initiators = new ArrayList<com.huawei.ism.base.sdk.model.Initiator>();
        Collection ports = v1Host.getAllHostPorts();
        for (Port port : ports) {
            if (!(port instanceof Initiator)) continue;
            Initiator v1Initiator = (Initiator)port;
            com.huawei.ism.base.sdk.model.Initiator initiator = ArrayDiscoverUtil.transitionInitiator(v1Initiator);
            initiator.setHostUUID(v1Host.getUUID());
            initiator.setUuid(port.getUUID());
            initiator.setParentMo((ManagedObject)array);
            initiator.setTopMoUuid(array.getTopMoUuid());
            initiators.add(initiator);
        }
        List oldInitList = moDao.getMoList(com.huawei.ism.base.sdk.model.Initiator.class, "hostUUID", (Object)v1Host.getUUID());
        this.saveOrUpdateMoAndDeleteOldMoRelationShip(moDao, initiators, oldInitList);
    }

    @Override
    public String handleType() {
        return "ISM_ProtocolController";
    }

    private void saveOrUpdateMoAndDeleteOldMoRelationShip(IMoDao moDao, List<com.huawei.ism.base.sdk.model.Initiator> newMos, List<com.huawei.ism.base.sdk.model.Initiator> oldMos) {
        if (VerifyUtil.isEmpty(newMos) && VerifyUtil.isEmpty(oldMos)) {
            return;
        }
        HashMap<String, com.huawei.ism.base.sdk.model.Initiator> uuidAndMoIdMap = new HashMap<String, com.huawei.ism.base.sdk.model.Initiator>();
        if (!VerifyUtil.isEmpty(oldMos)) {
            for (com.huawei.ism.base.sdk.model.Initiator oldMo : oldMos) {
                uuidAndMoIdMap.put(oldMo.getUuid(), oldMo);
            }
        }
        if (!VerifyUtil.isEmpty(newMos)) {
            for (com.huawei.ism.base.sdk.model.Initiator newMo : newMos) {
                uuidAndMoIdMap.remove(newMo.getUuid());
                moDao.saveOrUpdateMo((ManagedObject)newMo);
            }
        }
        for (com.huawei.ism.base.sdk.model.Initiator initiator : uuidAndMoIdMap.values()) {
            initiator.setHostUUID(null);
            moDao.onlyUpdate((ManagedObject)initiator);
        }
    }
}

