/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.handler;

import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.HashMap;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class InitiatorHandler
implements IHandler {
    private static final String HBA_TYPE_ISCSI = "1";
    private static final String HBA_TYPE_FC = "2";
    private static final String HBA_TYPE_SAS = "3";
    private final Log logger = LogFactory.getInstance((Object)this);

    @Override
    public void handle(Notification msg) {
        String deviceId = msg.getConnection().getArrayId();
        this.logger.info((Object)("-----> InitiatorHandler handle ... " + deviceId), 90160777658372L);
        IMoDao moDao = CommonDAOLocator.getMoDao();
        StorageUnit unit = (StorageUnit)moDao.getMo(StorageUnit.class, "devSn", (Object)deviceId);
        if (unit == null) {
            return;
        }
        if ("CIM_InstDeletion".equals(msg.getActionType())) {
            String uuid = WbemUtil.getUuidOfComponent((CIMObjectPath)msg.getTmpInstance().getObjectPath());
            Initiator initiator = (Initiator)moDao.getMo(Initiator.class, "uuid", (Object)uuid);
            if (null != initiator && VerifyUtil.isEmpty((String)initiator.getHostUUID())) {
                moDao.deleteMoWithoutMsg(initiator.getMoId());
            }
        } else {
            Initiator initiator = new Initiator();
            HashMap properties = WbemUtil.assembleProperties((CIMInstance)msg.getTmpInstance());
            initiator.setUuid(WbemUtil.getStrProperty((HashMap)properties, (String)"InstanceID"));
            initiator.setName(WbemUtil.getStrProperty((HashMap)properties, (String)"StorageID"));
            initiator.setIdentity(initiator.getName());
            if (HBA_TYPE_ISCSI.equals(WbemUtil.getUint64Property((HashMap)properties, (String)"IDType"))) {
                initiator.setHbaType(TypeEnum.ProtocolType.ISCSI.name());
            } else if (HBA_TYPE_FC.equals(WbemUtil.getUint64Property((HashMap)properties, (String)"IDType"))) {
                initiator.setHbaType(TypeEnum.ProtocolType.FC.name());
            } else if (HBA_TYPE_SAS.equals(WbemUtil.getUint64Property((HashMap)properties, (String)"IDType"))) {
                initiator.setHbaType(TypeEnum.ProtocolType.SAS.name());
            }
            initiator.setParentMo((ManagedObject)unit);
            initiator.setTopMoUuid(unit.getTopMoUuid());
            moDao.saveOrUpdateMo((ManagedObject)initiator);
        }
    }

    @Override
    public String handleType() {
        return "ISM_StorageHardwareID";
    }
}

