/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.listener;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.cbb.proxy.indication.IListener;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.common.bean.CommonState;
import com.huawei.ism.message.IsmMsg;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class SmisIsmMsgListener
implements IListener {
    private final Log logger = LogFactory.getInstance((Object)this);

    @Override
    public void notifyMsg(Notification notification) {
        String type = notification.getActionType();
        IsmMsg ismObj = (IsmMsg)notification.getAttribute("device.entityobject");
        if (null == ismObj) {
            this.logger.error((Object)"ismObj is null");
            return;
        }
        if ("MSG_TYPE_AUTHENTICATE_FAIL".equals(type)) {
            this.logger.info((Object)"Authenticate failed", 90160777658372L);
        } else if ("MSG_TYPE_REFRESH_DEVICE".equals(type)) {
            String devSn = (String)ismObj.getProperty((Object)"DEVICE_ID");
            this.logger.info((Object)("MSG_TYPE_REFRESH_DEVICE received, sn=" + devSn), 90160758784000L);
        } else if ("MSG_TYPE_CONNECTION_STATUS".equals(type)) {
            String deviceId = (String)ismObj.getProperty((Object)"DEVICE_ID");
            CommonState state = (CommonState)ismObj.getProperty((Object)"PROPERTY_COMMON_STATE");
            this.processConnectStateChange(deviceId, state);
        }
    }

    private void processConnectStateChange(String deviceId, CommonState state) {
        StorageNE storageNe = (StorageNE)CommonDAOLocator.getMoDao().getMo(StorageNE.class, "sn", (Object)deviceId);
        if (null != storageNe) {
            Istatus devStatus = GlobalDeviceStatus.getStatus((String)storageNe.getUuid(), DefaultOnlineToOfflineStatus.class);
            if (CommonState.FAULT.equals((Object)state)) {
                devStatus.doAction((ManagedObject)storageNe, -1);
            } else if (CommonState.NORMAL.equals((Object)state)) {
                devStatus.doAction((ManagedObject)storageNe, 0);
                DiscoverUtil.updateNetworkEntityStatus((NetworkEntity)storageNe, (int)0);
            }
        }
    }
}

