/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.listener;

import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.commons.IndicationParser;
import com.huawei.ism.cbb.proxy.indication.IListener;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SmisTrapListener
implements IListener {
    private final Log logger = LogFactory.getInstance((Object)this);
    private final Set<IHandler> handlers;
    private final Set<IHandler> handlersEx = new HashSet<IHandler>();

    public SmisTrapListener(Set<IHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void notifyMsg(Notification notification) {
        String type = notification.getActionType();
        if (type.equals("ISM_InstUpdate")) {
            String devSn = this.getDeviceId(notification);
            this.logger.info((Object)("INDICATION_ISM_InstUpdate received, sn=" + devSn), 90160758784000L);
        } else if ("CIM_InstDeletion".equals(type) || "CIM_InstCreation".equals(type) || "CIM_InstModification".equals(type) || "ISM_ReportIndication".equals(type)) {
            String entityType = IndicationParser.parseCim(notification);
            this.logger.debug((Object)("----> received trap message - target : " + entityType), 90160777658624L);
            try {
                this.processHandler(notification, entityType);
                this.processExtendHandler(notification, entityType);
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception when handle notification : " + entityType + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784257L);
            }
        }
    }

    private void processHandler(Notification notification, String entityType) {
        for (IHandler handler : this.handlers) {
            String handlerType = handler.handleType();
            if (!handlerType.equals(entityType)) continue;
            handler.handle(notification);
            break;
        }
    }

    private void processExtendHandler(Notification notification, String entityType) {
        if (!VerifyUtil.isEmpty(this.handlersEx)) {
            for (IHandler handler : this.handlersEx) {
                if (!handler.handleType().equals(entityType)) continue;
                handler.handle(notification);
            }
        }
    }

    private String getDeviceId(Notification notification) {
        Connection connection = notification.getConnection();
        if (null == connection || VerifyUtil.isEmpty((String)connection.getArrayId())) {
            return null;
        }
        return connection.getArrayId();
    }

    public void onBind(IHandler handler, Map<String, String> map) {
        this.handlersEx.add(handler);
    }

    public void onUnbind(IHandler handler, Map<String, String> map) {
        this.handlersEx.remove(handler);
    }
}

