/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.IpUtil;
import com.huawei.ism.cbb.discover.xve.TLVChangeHandler;
import com.huawei.ism.cbb.discover.xve.XveUtil;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.BitUtils;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.NetUtil;
import com.huawei.ism.cbb.proxy.protocol.tlv.constant.TLVUtils;
import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.DataPackage;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RegisterTlvIndicationProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(RegisterTlvIndicationProcessor.class);
    private static volatile RegisterTlvIndicationProcessor instance;
    private static final int TIMEOUT_DURATION = 30000;
    private static final int MSG_HEAD_LENGTH = 28;
    private static final int MSG_STATE_LENGTH = 4;
    private Set<IHandler> handlers;
    private final Set<IHandler> handlersEx = new HashSet<IHandler>();
    private final Map<String, TLVMonitorThread> processorThreadMap = new HashMap<String, TLVMonitorThread>();

    public Set<IHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Set<IHandler> handlers) {
        this.handlers = handlers;
    }

    public void clean(AbstractContext cmd) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext cmd) {
    }

    public static RegisterTlvIndicationProcessor getInstance() {
        if (null == instance) {
            instance = new RegisterTlvIndicationProcessor();
        }
        return instance;
    }

    public boolean process(AbstractContext context) {
        StorageNE device = (StorageNE)context.getAttribute("StorageDevice");
        StorageNE storageArray = (StorageNE)context.getAttribute("StorageArray");
        if (null == device || null == storageArray) {
            logger.error((Object)("When Register Report.device = " + device + " storageArray=" + storageArray), 90160777658373L);
            return false;
        }
        List manageIps = IpUtil.getMgrIps((NetworkEntity)storageArray);
        NeMgrProtocolExtend neMgrProtocolExtend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        String deviceID = device.getSn();
        TLVConnection con = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceID);
        if (null == con) {
            logger.error((Object)("connection is null, sn=" + deviceID));
            throw new LegoCheckedException(1073947649L);
        }
        con.setDeviceId(deviceID);
        logger.info((Object)"Now to Build a new Register Processor!", 90160777658372L);
        try {
            RegisterTlvIndicationProcessor.getInstance().registerNotificationProcessor(con, manageIps, neMgrProtocolExtend);
        }
        catch (Exception ex) {
            logger.error((Object)"First Build Socket Error", 90160777658373L);
        }
        return true;
    }

    public void registerNotificationProcessor(TLVConnection tlvConnection, List<String> manageIps, NeMgrProtocolExtend neMgrProtocolExtend) {
        Socket socket;
        logger.info((Object)("Begin Register Processor. processorThreadMap.containsKey=" + this.processorThreadMap.containsKey(tlvConnection.getDeviceId()) + " DeviceID=" + tlvConnection.getDeviceId()), 90160777658372L);
        if (this.processorThreadMap.containsKey(tlvConnection.getDeviceId())) {
            return;
        }
        try {
            socket = this.buildMonitorSocket(tlvConnection.getUrl());
            logger.info((Object)("succeed build socket for notification on ip :" + tlvConnection.getUrl()));
        }
        catch (Exception e) {
            logger.error((Object)("failed build socket for notification on ip :" + tlvConnection.getUrl()));
            throw new TLVException("Build Socket Error", (Throwable)e);
        }
        TLVMonitorThread processorThread = new TLVMonitorThread(socket, tlvConnection, manageIps, neMgrProtocolExtend);
        this.processorThreadMap.put(tlvConnection.getDeviceId(), processorThread);
        processorThread.setName("TV2 Report Thread");
        logger.info((Object)("Regist Processor Success. Thread is " + processorThread), 90160777658372L);
        processorThread.start();
    }

    public void stopNotificationProcessing(TLVConnection tlvConnection) {
        if (!this.processorThreadMap.containsKey(tlvConnection.getDeviceId())) {
            return;
        }
        TLVMonitorThread processorThread = this.processorThreadMap.get(tlvConnection.getDeviceId());
        logger.info((Object)("Stop Report Thread.processorThreadMap=" + this.processorThreadMap + " TLVMonitorThread is " + processorThread), 90160777658372L);
        processorThread.setRunning(false);
        processorThread.interrupt();
        logger.info((Object)"stop to receive notification.", 90160777658372L);
        this.processorThreadMap.remove(tlvConnection.getDeviceId());
        Socket socket = processorThread.getSocket();
        if (socket.isClosed()) {
            return;
        }
        try {
            this.sendStopNofifyCommand(socket, tlvConnection.getSessionKey());
        }
        catch (Exception e) {
            logger.error((Object)("StopNofifyCommand Error " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            logger.error((Object)"close socket for notification fail.", 90160777658373L);
        }
    }

    private void sendStopNofifyCommand(Socket socket, String sessionKey) {
        try {
            DataPackage dp = TLVUtils.param2DP(55847747635L, sessionKey, new ArrayList<Param>());
            socket.getOutputStream().write(dp.toByteArray());
            socket.getOutputStream().flush();
        }
        catch (Exception e) {
            logger.error((Object)"executing stop notify command fail.", 90160777658373L);
            throw new TLVException("StopNofifyCommand Error", (Throwable)e);
        }
    }

    private void sendStartNotifyCommand(Socket socket, String sessionKey) throws IOException {
        try {
            DataPackage dp = TLVUtils.param2DP(1L, sessionKey, new ArrayList<Param>());
            socket.getOutputStream().write(dp.toByteArray());
            socket.getOutputStream().flush();
            this.buildDataPackage(socket);
        }
        catch (Exception e) {
            logger.error((Object)"executing start_notify command fail.", 90160777658373L);
            throw new TLVException("Start_notify Fail", (Throwable)e);
        }
    }

    private DataPackage buildDataPackage(Socket socket) throws IOException {
        InputStream inputStream = socket.getInputStream();
        byte[] receiveMessageHead = new byte[28];
        this.fillBuffer(receiveMessageHead, inputStream);
        byte[] tmp4Byte = new byte[4];
        System.arraycopy(receiveMessageHead, 8, tmp4Byte, 0, 4);
        System.arraycopy(receiveMessageHead, 24, tmp4Byte, 0, 4);
        int messagesBodyLength = BitUtils.bytes2int((byte[])tmp4Byte, (boolean)false);
        byte[] receiveMessageBody = new byte[messagesBodyLength];
        this.fillBuffer(receiveMessageBody, inputStream);
        byte[] message = new byte[28 + messagesBodyLength];
        System.arraycopy(receiveMessageHead, 0, message, 0, 28);
        System.arraycopy(receiveMessageBody, 0, message, 28, receiveMessageBody.length);
        return TLVUtils.decode(message);
    }

    private void fillBuffer(byte[] dataBuffer, InputStream inputStream) throws IOException {
        int totalReadBytes = 0;
        for (int i = 0; i < 10; ++i) {
            int onceReadBytes = inputStream.read(dataBuffer, totalReadBytes, dataBuffer.length - totalReadBytes);
            if (onceReadBytes > -1) {
                totalReadBytes += onceReadBytes;
            }
            if (totalReadBytes == dataBuffer.length) break;
        }
        if (totalReadBytes < dataBuffer.length) {
            logger.info((Object)"Recive Data Error.", 90160777658373L);
            throw new LegoCheckedException(16797698L);
        }
    }

    private Socket buildMonitorSocket(String url) throws IOException {
        Socket socket = null;
        try {
            socket = NetUtil.connect((String)url, (int)8080, null);
            socket.setSoTimeout(30000);
            socket.setReceiveBufferSize(0x100000);
            socket.setKeepAlive(true);
            logger.info((Object)("Build Socket Success.Socket info =" + socket));
            return socket;
        }
        catch (SocketException e) {
            CommonUtil.close(socket);
            throw e;
        }
    }

    public void onBind(IHandler handler, Map<String, String> map) {
        this.handlersEx.add(handler);
    }

    public void onUnbind(IHandler handler, Map<String, String> map) {
        this.handlersEx.remove(handler);
    }

    private class TLVMonitorThread
    extends Thread {
        private final Socket socket;
        private TLVConnection connection;
        private boolean isRunning;
        private List<String> manageIps;
        private final NeMgrProtocolExtend neMgrProtocolExtend;

        public TLVMonitorThread(Socket socket, TLVConnection connection, List<String> manageIps, NeMgrProtocolExtend neMgrProtocolExtend) {
            this.socket = socket;
            this.connection = connection;
            this.isRunning = true;
            this.manageIps = manageIps;
            this.neMgrProtocolExtend = neMgrProtocolExtend;
        }

        @Override
        public void run() {
            logger.info((Object)"New Thread Begin.....");
            try {
                RegisterTlvIndicationProcessor.this.sendStartNotifyCommand(this.socket, this.connection.getSessionKey());
                logger.info((Object)"Start to receive Report notification.");
            }
            catch (IOException e) {
                logger.error((Object)"Send Report Start command Error.");
                CommonUtil.close((Closeable)this.socket);
                return;
            }
            catch (Exception e) {
                logger.error((Object)"Send Report Start command Error.");
                CommonUtil.close((Closeable)this.socket);
                return;
            }
            this.processReceivingDataPackage();
        }

        private void processReceivingDataPackage() {
            block4: {
                logger.info((Object)"Begin to Receive Data", 90160777658372L);
                try {
                    this.getReportData();
                }
                catch (Exception e) {
                    logger.error((Object)("Get Report Data,isRunning?" + this.isRunning + " getDeviceID=" + this.connection.getDeviceId() + " Exception: processorThreadMap=" + RegisterTlvIndicationProcessor.this.processorThreadMap), 90160777658372L);
                    if (!this.isRunning) break block4;
                    RegisterTlvIndicationProcessor.this.processorThreadMap.remove(this.connection.getDeviceId());
                    try {
                        this.socket.close();
                    }
                    catch (IOException e1) {
                        logger.error((Object)"close socket for notification fail.", 90160777658372L);
                    }
                    logger.error((Object)"receive notification fail, do recover processing.", 90160777658372L);
                    this.recoverProcessing(this.connection);
                }
            }
        }

        private void getReportData() throws IOException {
            logger.debug((Object)("Get Report Data,isRunning?" + this.isRunning), 90160777658372L);
            while (this.isRunning) {
                try {
                    DataPackage receivedData = RegisterTlvIndicationProcessor.this.buildDataPackage(this.socket);
                    TLVChangeHandler changeHandler = new TLVChangeHandler(this.connection.getDeviceId());
                    changeHandler.setHandlers(RegisterTlvIndicationProcessor.this.handlers);
                    changeHandler.setHandlersEx(RegisterTlvIndicationProcessor.this.handlersEx);
                    changeHandler.notificationOccured(receivedData);
                }
                catch (Exception ex) {
                    if (XveUtil.socketIsNomal(this.connection)) {
                        logger.debug((Object)"Get Report info Time Out.But Socket is Nomal.", 90160777658372L);
                        continue;
                    }
                    logger.error((Object)("Get Report info Error And Socket is UnNomal." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
                    throw new IOException(ex);
                }
            }
        }

        private void recoverProcessing(TLVConnection conn) {
            boolean hasRecovered = false;
            String deviceID = conn.getDeviceId();
            logger.info((Object)("Begin to Recover.DeviceID is :" + deviceID + " isRunning=" + this.isRunning), 90160777658372L);
            while (this.isRunning && !hasRecovered) {
                try {
                    StorageNE storageNE = XveUtil.getTLVConn(deviceID, this.neMgrProtocolExtend, this.manageIps);
                    TLVConnection newConnection = (TLVConnection)ConnectionManager.getInstance().getConnection(deviceID);
                    if (null == newConnection) {
                        logger.error((Object)"newConnection is null.");
                        throw new LegoCheckedException(1073947649L);
                    }
                    newConnection.setDeviceId(deviceID);
                    List<String> managerIps = XveUtil.getNewManagerIps(storageNE, newConnection);
                    if (!VerifyUtil.isEmpty(managerIps)) {
                        this.setManageIps(managerIps);
                    }
                    this.setConnection(newConnection);
                    RegisterTlvIndicationProcessor.this.registerNotificationProcessor(newConnection, this.manageIps, this.neMgrProtocolExtend);
                    hasRecovered = true;
                }
                catch (Exception e) {
                    logger.error((Object)("Recover Report Error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658372L);
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (InterruptedException e1) {
                        logger.error((Object)"Thread is InterruptedException.", (Throwable)e1, 90160777658372L);
                    }
                }
                logger.info((Object)("Recover Result:hasRecovered=" + hasRecovered + " is Running=" + this.isRunning), 90160777658372L);
            }
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void setRunning(boolean isRunningValue) {
            this.isRunning = isRunningValue;
        }

        public void setConnection(TLVConnection connection) {
            this.connection = connection;
        }

        public void setManageIps(List<String> manageIps) {
            this.manageIps = manageIps;
        }
    }
}

