/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.storage.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.proxy.service.impl.ConnectionManagerSmisImpl;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.List;

public class SmisInitializeProcessor
implements IProcessor {
    private static Log logger = LogFactory.getInstance(SmisInitializeProcessor.class);

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean process(AbstractContext context) {
        StorageNE device = (StorageNE)context.getAttribute("StorageDevice");
        if (null == device) {
            logger.error((Object)"StorageDevice is null in the context.");
            throw new LegoCheckedException(1073947393L);
        }
        NeMgrProtocolExtend neMgrProtocolExtend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        ConnectionManagerSmisImpl connManager = new ConnectionManagerSmisImpl();
        String deviceId = device.getSn();
        if (!connManager.isConnected(deviceId)) {
            List manageIps = (List)context.getAttribute("AvailableIps");
            logger.info((Object)("Login into storage begin, sn=" + deviceId + ", ips=" + manageIps));
            StorageNE newDevice = connManager.connect(manageIps, neMgrProtocolExtend);
            if (null == newDevice) {
                logger.error((Object)("Login into storage failed, sn=" + deviceId));
                throw new LegoCheckedException(1073947649L);
            }
            device.setLinkIp(newDevice.getLinkIp());
            device.setIpAddress(newDevice.getIpAddress());
            logger.info((Object)("Login into storage end, sn=" + deviceId));
        }
        return true;
    }

    public void clean(AbstractContext context) {
    }

    public void postProcess(AbstractContext context) {
    }
}

