/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.util;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.util.TimeUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.entity.TypeEnum;
import com.huawei.ism.common.entity.components.Controller;
import com.huawei.ism.common.entity.components.TargetFcPort;
import com.huawei.ism.connection.tlv.TLVRecvData;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class DiscoverExUtil {
    private static final Log LOGGER = LogFactory.getInstance(DiscoverExUtil.class);

    public static boolean isS5600V1R1Unit(StorageUnit unit) {
        return null != unit && "S5600(V100R001)".equals(unit.getSubType());
    }

    public static NeMgrProtocolExtend parseExtendParams(SynchronizeParameter param) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(param.getDeviceIp());
        neMgrExtend.setOtherParam(param.getLocation());
        DiscoveryPolicy policy = param.getDiscoveryPolicy();
        SnmpPara sp = null;
        int snmpVer = 0;
        if (null != param.getManagementProtocolMap()) {
            sp = (SnmpPara)param.getManagementProtocolMap().get("com.huawei.lego.com.south.sdk.model.SnmpPara");
        }
        if (null != sp) {
            snmpVer = sp.getVersion();
        }
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return neMgrExtend;
        }
        Map paramMap = policy.getParamMap();
        neMgrExtend.setNetworkUserName((String)paramMap.get("name"));
        neMgrExtend.setNetworkPassword((String)paramMap.get("password"));
        Map extendParams = DiscoverUtil.getExtendParams((Map)paramMap, (int)snmpVer);
        neMgrExtend.setExtendParams(extendParams);
        LOGGER.info((Object)"out NeMgrProtocolExtend", 90160777658372L);
        return neMgrExtend;
    }

    public static NeMgrProtocolExtend parseHuaweiStorageParams(SynchronizeParameter param) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(param.getDeviceIp());
        neMgrExtend.setOtherParam(param.getLocation());
        DiscoveryPolicy policy = param.getDiscoveryPolicy();
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            return neMgrExtend;
        }
        Map extendParams = neMgrExtend.getExtendParams();
        Map paramMap = policy.getParamMap();
        String protocol = (String)paramMap.get("protocol");
        extendParams.put("protocol", protocol);
        if ("DEFAULT".equals(protocol) || "REST".equals(protocol) || "FSB-REST".equals(protocol)) {
            neMgrExtend = DiscoverExUtil.parseExtendParams(param);
            neMgrExtend.getExtendParams().put("protocol", protocol);
        }
        return neMgrExtend;
    }

    public static void updateTimeZoneToMo(ManagedObject mo, String deviceId) {
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
        TimeZone timeZone = TimeZone.getDefault();
        if (null != launcher && null != launcher.getDeviceTimeZone()) {
            timeZone = launcher.getDeviceTimeZone();
        }
        String timezoneFormat = TimeUtil.getTimeZoneOffset((TimeZone)timeZone);
        mo.setTimezoneFormat(timezoneFormat);
    }

    public static boolean updateAlarmSource(String oldName, String newName, TopoObject topoObjectInDB) {
        if (null == oldName || null == newName) {
            return false;
        }
        if (!oldName.trim().equals(newName.trim())) {
            LOGGER.info((Object)("New name is " + newName + ", old name is " + oldName), 90160758784256L);
            try {
                topoObjectInDB.setName(newName);
                ServiceContext context = ServiceContext.getInstance();
                IAlarmService alarmService = (IAlarmService)context.lookup("fault/alarmService");
                alarmService.updateFault(topoObjectInDB);
                LOGGER.info((Object)("Array name has been changed, old name is " + oldName + ", new name is " + newName), 90160758784256L);
                return true;
            }
            catch (Exception e) {
                LOGGER.info((Object)("Failed to update alarm sources. Array name has been changed, old name is " + oldName + ", new name is " + newName), 90160758784257L);
            }
        }
        return false;
    }

    public static void parseFcMode(Controller controller, TargetFcPort targetFcPort, List<TLVRecvData> recvDatas) {
        if (null == controller || null == targetFcPort || VerifyUtil.isEmpty(recvDatas)) {
            LOGGER.info((Object)"the controller or targetFcPort or recvDatas is null ", 90160777658389L);
            return;
        }
        for (TLVRecvData recvData : recvDatas) {
            if (recvData.getUint32Property(0) != controller.getControllerId() || recvData.getUint32Property(1) != targetFcPort.getBoardID() || recvData.getUint32Property(2) != targetFcPort.getPortID()) continue;
            targetFcPort.setFcPortMode(TypeEnum.FCModeType.getFCModeType((int)((int)recvData.getUint32Property(3))));
            break;
        }
    }
}

