/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveCreateHandler;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.DataPackage;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.protocol.tlv.notification.INotificationHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;
import java.util.Set;

public class TLVChangeHandler
implements INotificationHandler {
    private String deviceID = null;
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");
    private Set<IHandler> handlers;
    private Set<IHandler> handlersEx;

    public TLVChangeHandler(Set<IHandler> handlers) {
        this.handlers = handlers;
    }

    public TLVChangeHandler(String deviceID) {
        this.deviceID = deviceID;
    }

    public Set<IHandler> getHandlers() {
        return this.handlers;
    }

    public Set<IHandler> getHandlersEx() {
        return this.handlersEx;
    }

    @Override
    public void notificationOccured(Object o) {
        if (!(o instanceof DataPackage)) {
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        NetworkEntity netWork = (NetworkEntity)moDao.getMo(NetworkEntity.class, "sn", (Object)this.deviceID);
        if (null == netWork) {
            return;
        }
        DataPackage dataPackage = (DataPackage)o;
        List records = dataPackage.getRecordset();
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().getConnection(this.deviceID);
        for (Record record : records) {
            Notification notification;
            String idValue;
            IsmInteger typeValue;
            long opCode = record.getMsgCode();
            if (opCode == 55847747637L || opCode == 55847747638L) {
                typeValue = record.getParamIntValue(0);
                if (null == typeValue) {
                    this.logger.error((Object)"typeValue is null.");
                    continue;
                }
                idValue = record.getParamStrValue(1);
                this.logger.debug((Object)("The detail of the received notification is [operationCode: " + opCode + ", objectType: " + typeValue.intValue() + ", id:" + idValue + "]"), 90160777658372L);
                notification = this.getNotification(connection, opCode, (Number)typeValue, idValue);
                try {
                    this.processHandler(notification, String.valueOf(typeValue));
                    this.processHandlerEx(notification, String.valueOf(typeValue));
                }
                catch (Exception e) {
                    this.logger.error((Object)("Exception when handle notification : " + typeValue + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784257L);
                }
                continue;
            }
            if (opCode != 55847747636L) continue;
            typeValue = record.getParamIntValue(0);
            idValue = record.getParamStrValue(1);
            this.logger.info((Object)("TLV recive notiy create information, the type: " + typeValue + ", id: " + idValue));
            if (null == typeValue) {
                this.logger.error((Object)"typeValue is null.");
                continue;
            }
            notification = this.getNotification(connection, opCode, (Number)typeValue, idValue);
            XveCreateHandler.getInstance().createHandler(notification);
            this.processHandlerEx(notification, String.valueOf(typeValue));
        }
    }

    private Notification getNotification(TLVConnection connection, long opCode, Number typeValue, String idValue) {
        Notification notification = new Notification();
        notification.setAttribute("deviceID", this.deviceID);
        notification.setAttribute("conn", connection);
        notification.setAttribute("typeValue", typeValue.intValue());
        notification.setAttribute("idValue", idValue);
        notification.setAttribute("reportType", opCode);
        return notification;
    }

    private void processHandler(Notification notification, String entityType) {
        for (IHandler handler : this.handlers) {
            if (!handler.handleType().equals(entityType)) continue;
            handler.handle(notification);
            break;
        }
    }

    private void processHandlerEx(Notification notification, String entityType) {
        for (IHandler handler : this.handlersEx) {
            if (!handler.handleType().equals(entityType)) continue;
            handler.handle(notification);
        }
    }

    public void setHandlers(Set<IHandler> handlers) {
        this.handlers = handlers;
    }

    public void setHandlersEx(Set<IHandler> handlersEx) {
        this.handlersEx = handlersEx;
    }
}

