/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.util.DiscoverExUtil;
import com.huawei.ism.cbb.discover.xve.ConnectionManagerTlvImpl;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;

public class TlvSynchronizer
extends AbstractSynchronizer {
    private final Log logger = LogFactory.getInstance((Object)((Object)this));

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter para, MoListOrMap moListOrMap) {
        this.logger.info((Object)("Begin discover TLV storage device, ip=" + para.getDeviceIp()), 90160777658372L);
        CommonTemplate discoverTemplate = CommonTemplateManager.getInstance().getTemplateByManagementProtocol("TLV", 1);
        if (null == discoverTemplate) {
            this.logger.error((Object)("Get device discover common template failed, device IP:" + para.getDeviceIp()), 90160777658373L);
            throw new LegoCheckedException(127402L);
        }
        NeMgrProtocolExtend neMgrExtend = DiscoverExUtil.parseExtendParams(para);
        ArrayList<String> manageIps = new ArrayList<String>();
        manageIps.add(para.getDeviceIp());
        StorageNE storageNe = this.createConnectionAndBasicInfo(manageIps, neMgrExtend);
        if (null == storageNe) {
            this.logger.error((Object)("TLV storage device info is null, ip=" + para.getDeviceIp()), 90160777658373L);
            throw new LegoCheckedException(132427L);
        }
        storageNe.setIpAddress(para.getDeviceIp());
        storageNe.setManagementProtocolMap(para.getManagementProtocolMap());
        DiscoverContext context = new DiscoverContext(para, moListOrMap);
        context.setAttribute("StorageDevice", (Object)storageNe);
        context.setAttribute("NeMgrProtocolExtend", (Object)neMgrExtend);
        context.setAttribute("AvailableIps", manageIps);
        context.setAttribute("SiteId", (Object)para.getDiscoveryPolicy().getLocation());
        context.setAttribute("OperatorId", (Object)para.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
        this.logger.info((Object)("End discover TLV storage device, ip=" + para.getDeviceIp()), 90160777658372L);
        return null;
    }

    private StorageNE createConnectionAndBasicInfo(List<String> manageIps, NeMgrProtocolExtend neMgrExtend) {
        try {
            ConnectionManagerTlvImpl connectionManager = new ConnectionManagerTlvImpl();
            return connectionManager.connect(manageIps, neMgrExtend);
        }
        catch (LegoCheckedException ex) {
            this.logger.error((Object)"Query TLV storage device info failed.", (Throwable)ex, 90160758784000L);
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Query VIS storage device info failed.", (long)132427L, null, (Log)this.logger);
            return null;
        }
    }
}

