/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.concurrent.TimeUnit;

public class StoragePoolChanageRunner
implements Runnable {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");
    private final Notification msg;

    public StoragePoolChanageRunner(Notification msg) {
        this.msg = msg;
    }

    @Override
    public void run() {
        this.logger.debug((Object)"begin to deal storage pool notify info", 90160777658372L);
        try {
            TimeUnit.SECONDS.sleep(30L);
            XveStoragePool xveStoragePoolOld = (XveStoragePool)XveHandlerComm.getInstance().getOldInfo(this.msg, "xveStoragePool");
            if (null == xveStoragePoolOld) {
                return;
            }
            XveStoragePool xveStoragePoolNew = XveHandlerComm.getInstance().getNewStoragePool(this.msg);
            this.setFromNewToOld(xveStoragePoolNew, xveStoragePoolOld);
            IMoDao moDao = CommonDAOLocator.getMoDao();
            moDao.onlyUpdateWithoutMsg((ManagedObject)xveStoragePoolOld);
            XveHandlerComm.getInstance().getTv2Capacity(this.msg);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e, 90160777658373L);
        }
        this.logger.debug((Object)"End to deal storage pool notify info", 90160777658372L);
    }

    private void setFromNewToOld(XveStoragePool from, XveStoragePool to) {
        if (null != from && null != to) {
            to.setPoolId(from.getPoolId());
            to.setName(from.getName());
            to.setStatus(from.getStatus());
            to.setHealthStatus(from.getHealthStatus());
            to.setRunningStatus(from.getRunningStatus());
            to.setTier0DiskList(from.getTier0DiskList());
            to.setTier0DiskNum(from.getTier0DiskNum());
            to.setTier0DiskType(from.getTier0DiskType());
            to.setTier0HotspareSpaceStrategy(from.getTier0HotspareSpaceStrategy());
            to.setTier0RaidDiskNum(from.getTier0RaidDiskNum());
            to.setTier0RaidLv(from.getTier0RaidLv());
            to.setTier0FreeCapacity(from.getTier0FreeCapacity());
            to.setTier0UsedCapacity(from.getTier0UsedCapacity());
            to.setTier1DiskList(from.getTier1DiskList());
            to.setTier1DiskNum(from.getTier1DiskNum());
            to.setTier1DiskType(from.getTier1DiskType());
            to.setTier1HotspareSpaceStrategy(from.getTier1HotspareSpaceStrategy());
            to.setTier1RaidDiskNum(from.getTier1RaidDiskNum());
            to.setTier1RaidLv(from.getTier1RaidLv());
            to.setTier1FreeCapacity(from.getTier1FreeCapacity());
            to.setTier1UsedCapacity(from.getTier1UsedCapacity());
            to.setTier2DiskList(from.getTier2DiskList());
            to.setTier2DiskNum(from.getTier2DiskNum());
            to.setTier2DiskType(from.getTier2DiskType());
            to.setTier2HotspareSpaceStrategy(from.getTier2HotspareSpaceStrategy());
            to.setTier2RaidDiskNum(from.getTier2RaidDiskNum());
            to.setTier2RaidLv(from.getTier2RaidLv());
            to.setTier2FreeCapacity(from.getTier2FreeCapacity());
            to.setTier2UsedCapacity(from.getTier2UsedCapacity());
            to.setTotalCapacity(from.getTotalCapacity());
            to.setTotalCapacityUnit(from.getTotalCapacityUnit());
            to.setUsedCapacity(from.getUsedCapacity());
            to.setUsedCapacityUnit(from.getUsedCapacityUnit());
            to.setFreeCapacity(from.getFreeCapacity());
            to.setHotspareSpaceConsumedCapacity(from.getHotspareSpaceConsumedCapacity());
            to.setHotspareSpaceConsumedCapacityUnit(from.getHotspareSpaceConsumedCapacityUnit());
            to.setHotspareSpaceTotalCapacity(from.getHotspareSpaceTotalCapacity());
            to.setHotspareSpaceTotalCapacityUnit(from.getHotspareSpaceTotalCapacityUnit());
            to.setThreshold(from.getThreshold());
        }
    }
}

