/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.util.DiscoverExUtil;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;

public class XveArrayHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            XveUnit xveUnitOld = (XveUnit)XveHandlerComm.getInstance().getOldInfo(msg, "xveUnit");
            if (null == xveUnitOld) {
                return;
            }
            String oldname = xveUnitOld.getName();
            Double oldTotalCapactiy = xveUnitOld.getTotalCapacity();
            XveUnit xveUnitNew = XveHandlerComm.getInstance().getNewXveUnit(msg);
            xveUnitNew.setName(oldname);
            this.setOldtoNewUnit(xveUnitNew, xveUnitOld);
            modao.onlyUpdate((ManagedObject)xveUnitOld);
            ManagedObject parentMo = (ManagedObject)modao.get((Serializable)xveUnitOld.getParentId());
            XveStorage xveStorageNew = null;
            if (parentMo instanceof XveStorage) {
                XveStorage storageArray = (XveStorage)parentMo;
                xveStorageNew = this.setOldtoNewStorage(storageArray, xveUnitNew);
            }
            modao.onlyUpdate(xveStorageNew);
            XveStorage oldXveStorage = new XveStorage();
            oldXveStorage.setTotalCapacity(oldTotalCapactiy);
            DiscoverExUtil.updateAlarmSource(oldname, xveUnitNew.getName(), (TopoObject)((XveStorage)parentMo));
            this.logger.info((Object)("---> Save array : " + xveUnitOld), 90160777658372L);
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveArrayHandler Exception : array report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.SYSTEM.getValue());
    }

    private void setOldtoNewUnit(XveUnit from, XveUnit to) {
        if (null != from && null != to) {
            to.setDevSn(from.getDevSn());
            to.setProductModel(from.getProductModel());
            to.setName(from.getName());
            to.setDescription(from.getDescription());
            to.setProductVersion(from.getProductVersion());
            to.setStatus(from.getStatus());
            to.setMainType("ism.deviceType.storage.mainType");
            to.setSubType(from.getSubType());
        }
    }

    private XveStorage setOldtoNewStorage(XveStorage old, XveUnit xveUnitNew) {
        if (null != old && null != xveUnitNew) {
            old.setIsTopMo(Boolean.valueOf(true));
            old.setManaged(Boolean.valueOf(true));
            old.setStatus(xveUnitNew.getStatus());
            old.setTotalCapacity(xveUnitNew.getTotalCapacity());
            old.setTotalCapacityUnit(CapabilityUnitType.GB.name());
            old.setUsedCapacity(xveUnitNew.getUsedCapacity());
            old.setUsedCapacityUnit(CapabilityUnitType.GB.name());
            old.setName(xveUnitNew.getName());
        }
        return old;
    }
}

