/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

public class XveChassisHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Chassis xveChassisOld = (Chassis)XveHandlerComm.getInstance().getOldInfo(msg, "chassis");
            if (null == xveChassisOld) {
                return;
            }
            List<Chassis> xveChassisNew = XveHandlerComm.getInstance().getNewChassis(msg);
            this.setFromNewToOld(xveChassisNew, xveChassisOld);
            modao.onlyUpdate((ManagedObject)xveChassisOld);
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveChassisHandler Exception : Chassis report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.ENCLOSURE.getValue());
    }

    private void setFromNewToOld(List<Chassis> xveChassisNew, Chassis xveChassisOld) {
        if (!VerifyUtil.isEmpty(xveChassisNew) && null != xveChassisOld) {
            for (Chassis ch : xveChassisNew) {
                if (!ch.getUuid().equals(xveChassisOld.getUuid())) continue;
                xveChassisOld.setName(ch.getName());
                xveChassisOld.setStatus(ch.getStatus());
                xveChassisOld.setRunningState(ch.getRunningState());
                xveChassisOld.setHealthState(ch.getHealthState());
                xveChassisOld.setTemperature(ch.getTemperature());
                xveChassisOld.setHeight(ch.getHeight());
                xveChassisOld.setSerialNum(ch.getSerialNum());
                xveChassisOld.setLocation(ch.getLocation());
                xveChassisOld.setChassisModel(ch.getChassisModel());
                xveChassisOld.setLogicType(ch.getLogicType());
                break;
            }
        }
    }
}

