/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.XveIntfModule;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.service.XveDeviceProxy;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class XveControllersHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        try {
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "controller");
            } else if (reportType == 55847747637L) {
                Controller controllerOld = (Controller)XveHandlerComm.getInstance().getOldInfo(msg, "controller");
                if (null == controllerOld) {
                    return;
                }
                Controller controllerNew = XveHandlerComm.getInstance().getNewController(msg);
                this.dealControllerInfo(msg, moDao);
                this.setNewToOld(controllerNew, controllerOld);
                moDao.onlyUpdate((ManagedObject)controllerOld);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveControllersHandler Exception : Controller report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    private void dealControllerInfo(Notification msg, IMoDao moDao) {
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        String deviceID = (String)msg.getAttribute("deviceID");
        XveUnit xveUnit = (XveUnit)moDao.getMo(XveUnit.class, "devSn", (Object)deviceID);
        xveUnit.setChildMos(new HashSet());
        List oldControllers = moDao.getAllSubMo(xveUnit.getMoId().longValue(), Controller.class);
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        List<Controller> newControllers = xveDeviceProxy.getControllers(connection, xveUnit);
        this.deleteNotExistController(moDao, oldControllers, newControllers);
        this.createNewController(moDao, connection, xveUnit, oldControllers, xveDeviceProxy, newControllers);
    }

    private void createNewController(IMoDao moDao, TLVConnection connection, XveUnit xveUnit, List<Controller> oldControllers, XveDeviceProxy xveDeviceProxy, List<Controller> newControllers) {
        ArrayList<String> controllerUUIDList = new ArrayList<String>();
        if (null != oldControllers) {
            for (Controller controller : oldControllers) {
                controllerUUIDList.add(controller.getUuid());
            }
        }
        if (null != newControllers) {
            for (Controller controller : newControllers) {
                if (controllerUUIDList.contains(controller.getUuid())) continue;
                this.logger.info((Object)("Found new controller name:" + controller.getName()), 90160777658372L);
                List<XveIntfModule> intfModules = xveDeviceProxy.getIntfModules(connection, xveUnit, newControllers);
                xveDeviceProxy.getStorageEtherPort(connection, xveUnit, intfModules, newControllers);
                xveDeviceProxy.getHostFcPort(connection, xveUnit, intfModules, newControllers);
                xveDeviceProxy.getStorageSasPort(connection, xveUnit, intfModules, newControllers);
                controller.setParentMo((ManagedObject)xveUnit);
                xveUnit.addChildMo((ManagedObject)controller);
                moDao.addMoAndSubMo((ManagedObject)controller);
            }
        }
    }

    private void deleteNotExistController(IMoDao moDao, List<Controller> oldControllers, List<Controller> newControllers) {
        ArrayList<String> controllerUUIDList = new ArrayList<String>();
        if (null != newControllers) {
            for (Controller controller : newControllers) {
                controllerUUIDList.add(controller.getUuid());
            }
        }
        for (Controller controller : oldControllers) {
            if (controllerUUIDList.contains(controller.getUuid())) continue;
            this.logger.info((Object)("Delete controller from database, name:" + controller.getName()), 90160777658372L);
            moDao.deleteMo(controller.getMoId());
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.CONTROLLER.getValue());
    }

    private void setNewToOld(Controller controllerNew, Controller controllerOld) {
        if (null != controllerNew && null != controllerOld) {
            controllerOld.setControllerId(controllerNew.getControllerId());
            controllerOld.setLocation(controllerNew.getLocation());
            controllerOld.setName(controllerNew.getName());
            controllerOld.setStatus(controllerNew.getStatus());
            controllerOld.setHealthStatus(controllerNew.getHealthStatus());
            controllerOld.setRunningStatus(controllerNew.getRunningStatus());
            controllerOld.setIsMaster(controllerNew.getIsMaster());
            controllerOld.setCacheSize(controllerNew.getCacheSize());
            controllerOld.setCacheSizeUnit(CapabilityUnitType.MB.name());
            controllerOld.setChassisId(controllerNew.getChassisId());
            controllerOld.setPcbVersion(controllerNew.getPcbVersion());
            controllerOld.setSystemVersion(controllerNew.getSystemVersion());
        }
    }
}

