/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.XveIntfModule;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.base.port.sdk.model.IscsiHostPort;
import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class XveCreateHandler {
    private static final Log logger = LogFactory.getInstance(XveCreateHandler.class, (String)"UBase/Xve_Discover");
    private static XveCreateHandler instance;

    public static XveCreateHandler getInstance() {
        if (null == instance) {
            instance = new XveCreateHandler();
        }
        return instance;
    }

    private void createEthPort(Notification msg) {
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        String reportId = (String)msg.getAttribute("idValue");
        IMoDao moDao = CommonDAOLocator.getMoDao();
        XveUnit xveUnit = (XveUnit)XveHandlerComm.getInstance().getOldInfo(msg, "xveUnit");
        if (null == xveUnit) {
            return;
        }
        List controllers = moDao.getAllSubMo(xveUnit.getMoId().longValue(), Controller.class);
        logger.info((Object)("Create Eth port,Get Info from Db:XveUnit:" + xveUnit + " .Controller:" + controllers), 90160777658372L);
        if (VerifyUtil.isEmpty((Collection)controllers)) {
            return;
        }
        for (Controller con : controllers) {
            con.setChildMos(new HashSet());
        }
        List<XveIntfModule> intfModules = xveDeviceProxy.getIntfModules(connection, xveUnit, controllers);
        List<IscsiHostPort> newIsnsiHostPort = xveDeviceProxy.getStorageEtherPort(connection, xveUnit, intfModules, controllers);
        logger.info((Object)("Modules =" + intfModules + " IscHostPort=" + newIsnsiHostPort), 90160777658372L);
        if (null != newIsnsiHostPort) {
            for (IscsiHostPort port : newIsnsiHostPort) {
                if (VerifyUtil.isEmpty((String)reportId) || !reportId.equals(String.valueOf(port.getPortId()))) continue;
                logger.info((Object)("Create Eth Port : " + port), 90160777658372L);
                port.setTopMoUuid(xveUnit.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)port);
                break;
            }
        }
    }

    private void createFCPort(Notification msg) {
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        String reportId = (String)msg.getAttribute("idValue");
        IMoDao moDao = CommonDAOLocator.getMoDao();
        XveUnit xveUnit = (XveUnit)XveHandlerComm.getInstance().getOldInfo(msg, "xveUnit");
        if (null == xveUnit) {
            return;
        }
        List controllers = moDao.getAllSubMo(xveUnit.getMoId().longValue(), Controller.class);
        logger.info((Object)("Create FC port,Get Info from Db:XveUnit:" + xveUnit + " .Controller:" + controllers), 90160777658372L);
        if (VerifyUtil.isEmpty((Collection)controllers)) {
            return;
        }
        for (Controller con : controllers) {
            con.setChildMos(new HashSet());
        }
        List<XveIntfModule> intfModules = xveDeviceProxy.getIntfModules(connection, xveUnit, controllers);
        List<FcHostPort> newFcPort = xveDeviceProxy.getHostFcPort(connection, xveUnit, intfModules, controllers);
        logger.info((Object)("Modules =" + intfModules + "  FcPort=" + newFcPort), 90160777658372L);
        if (null != newFcPort) {
            for (FcHostPort port : newFcPort) {
                if (VerifyUtil.isEmpty((String)reportId) || !reportId.equals(String.valueOf(port.getPortId()))) continue;
                logger.info((Object)("Create Fc Port : " + port), 90160777658372L);
                port.setTopMoUuid(xveUnit.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)port);
                break;
            }
        }
    }

    public void createHandler(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            Integer createType = (Integer)msg.getAttribute("typeValue");
            if (null == createType) {
                logger.error((Object)"createType is null.");
                return;
            }
            XveHandlerComm handler = XveHandlerComm.getInstance();
            logger.info((Object)("Get Create info.." + XveMOType.getTypeName((int)createType)), 90160777658372L);
            if (createType.intValue() == XveMOType.DISK.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewDisks(msg), msg);
                XveHandlerComm.getInstance().getTv2Capacity(msg);
            } else if (createType.intValue() == XveMOType.STORAGEPOOL.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewStoragePool(msg), msg);
                XveHandlerComm.getInstance().getTv2Capacity(msg);
            } else if (createType.intValue() == XveMOType.MAPPINGVIEW.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewMappingView(msg), msg);
            } else if (createType.intValue() == XveMOType.LUN.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewLuns(msg), msg);
                XveHandlerComm.getInstance().setLunCapacity(msg);
            } else if (createType.intValue() == XveMOType.HOST.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewArrayHost(msg), msg);
            } else if (createType.intValue() == XveMOType.ISCSI_INITIATOR.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewInitiator(msg), msg);
            } else if (createType.intValue() == XveMOType.FC_INITIATOR.getValue()) {
                handler.setOwnTieAndSave((ManagedObject)handler.getNewInitiator(msg), msg);
            } else {
                this.getCreateType(createType, msg);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Error occured when create report.." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    private void createSASPort(Notification msg) {
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        String reportId = (String)msg.getAttribute("idValue");
        IMoDao moDao = CommonDAOLocator.getMoDao();
        XveUnit xveUnit = (XveUnit)XveHandlerComm.getInstance().getOldInfo(msg, "xveUnit");
        if (null == xveUnit) {
            return;
        }
        List controllers = moDao.getAllSubMo(xveUnit.getMoId().longValue(), Controller.class);
        logger.info((Object)("Create Sas port,Get Info from Db:XveUnit:" + xveUnit + " .Controller:" + controllers), 90160777658372L);
        if (VerifyUtil.isEmpty((Collection)controllers)) {
            return;
        }
        for (Controller con : controllers) {
            con.setChildMos(new HashSet());
        }
        List<XveIntfModule> intfModules = xveDeviceProxy.getIntfModules(connection, xveUnit, controllers);
        List<SasHostPort> newSasPort = xveDeviceProxy.getStorageSasPort(connection, xveUnit, intfModules, controllers);
        logger.info((Object)("Modules =" + intfModules + "  SasPort=" + newSasPort), 90160777658372L);
        if (null != newSasPort) {
            for (SasHostPort port : newSasPort) {
                if (VerifyUtil.isEmpty((String)reportId) || !reportId.equals(String.valueOf(port.getPortId()))) continue;
                logger.info((Object)("Create Sas Port : " + port), 90160777658372L);
                port.setTopMoUuid(xveUnit.getTopMoUuid());
                moDao.saveOrUpdateMo((ManagedObject)port);
                break;
            }
        }
    }

    private void getCreateType(Integer createType, Notification msg) {
        if (createType.intValue() == XveMOType.ETH_PORT.getValue()) {
            this.createEthPort(msg);
        } else if (createType.intValue() == XveMOType.SAS_PORT.getValue()) {
            this.createSASPort(msg);
        } else if (createType.intValue() == XveMOType.FC_PORT.getValue()) {
            this.createFCPort(msg);
        } else {
            logger.info((Object)("The type :" + XveMOType.getTypeName((int)createType) + "  is not supported to create..."), 90160777658372L);
        }
    }
}

