/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.XveDisk;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveDiskHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "disk");
                XveHandlerComm.getInstance().getTv2Capacity(msg);
            } else if (reportType == 55847747637L) {
                XveDisk xveDiskOld = (XveDisk)XveHandlerComm.getInstance().getOldInfo(msg, "xveDisk");
                if (null == xveDiskOld) {
                    return;
                }
                XveDisk xveDisksNew = XveHandlerComm.getInstance().getNewDisks(msg);
                this.setFromNewToOld(xveDisksNew, xveDiskOld);
                modao.onlyUpdate((ManagedObject)xveDiskOld);
                XveHandlerComm.getInstance().getTv2Capacity(msg);
                this.logger.info((Object)("---> Save Disk : " + xveDiskOld), 90160777658372L);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveDiskHandler Exception : disk report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    private void setFromNewToOld(XveDisk xveDisksNew, XveDisk xveDiskOld) {
        if (null != xveDisksNew && null != xveDiskOld) {
            xveDiskOld.setDiskPos(xveDisksNew.getDiskPos());
            xveDiskOld.setDiskType(xveDisksNew.getDiskType());
            xveDiskOld.setLogicalType(xveDisksNew.getLogicalType());
            xveDiskOld.setTotalCapacity(xveDisksNew.getTotalCapacity());
            xveDiskOld.setTotalCapacityUnit(xveDisksNew.getTotalCapacityUnit());
            xveDiskOld.setStatus(xveDisksNew.getStatus());
            xveDiskOld.setHealthStatus(xveDisksNew.getHealthStatus());
            xveDiskOld.setRunningStatus(xveDisksNew.getRunningStatus());
            xveDiskOld.setSpinSpeed(xveDisksNew.getSpinSpeed());
            xveDiskOld.setDiskRuntime(xveDisksNew.getDiskRuntime());
            xveDiskOld.setDiskSN(xveDisksNew.getDiskSN());
            xveDiskOld.setDiskId(xveDisksNew.getDiskId());
            xveDiskOld.setSerialNo(xveDisksNew.getSerialNo());
            xveDiskOld.setMoVersion(xveDisksNew.getMoVersion());
            xveDiskOld.setPhysicalModel(xveDisksNew.getPhysicalModel());
            xveDiskOld.setPoolId(xveDisksNew.getPoolId());
            xveDiskOld.setFirmwareNo(xveDisksNew.getFirmwareNo());
            xveDiskOld.setManufacture(xveDisksNew.getManufacture());
            xveDiskOld.setTemperature(xveDisksNew.getTemperature());
            xveDiskOld.setPoolTierUuid(xveDisksNew.getPoolTierUuid());
            xveDiskOld.setPoolName(xveDisksNew.getPoolName());
            xveDiskOld.setBarCode(xveDisksNew.getBarCode());
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.DISK.getValue());
    }
}

