/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.port.sdk.model.IscsiHostPort;
import com.huawei.ism.base.port.sdk.model.ManagementPort;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.V2TypeMapper;
import com.huawei.ism.cbb.discover.xve.XveUtil;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.xve.TLVParamUtil;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLVParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class XveEthPortHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "hostPort");
            } else if (reportType == 55847747637L) {
                ManagedObject xveHostPortOld = XveHandlerComm.getInstance().getOldInfo(msg, "hostPort");
                if (null == xveHostPortOld) {
                    return;
                }
                Record xveHostPortNew = XveHandlerComm.getInstance().getNewHostPort(msg);
                this.setFromNewToOld(xveHostPortOld, xveHostPortNew);
                modao.onlyUpdate(xveHostPortOld);
                if (xveHostPortOld instanceof ManagementPort) {
                    this.logger.info((Object)"Manager port Changed:", 90160777658372L);
                    ManagementPort mgPort = (ManagementPort)XveHandlerComm.getInstance().getOldInfo(msg, "hostPort");
                    if (null == mgPort) {
                        return;
                    }
                    Long parentMoId = mgPort.getParentMo().getMoId();
                    ManagedObject controller = (ManagedObject)modao.get((Serializable)parentMoId);
                    this.getManagerIps(controller);
                    this.setControlIpV6(controller);
                    modao.onlyUpdate(controller);
                    XveUnit xveUnitOld = (XveUnit)XveHandlerComm.getInstance().getOldInfo(msg, "xveUnit");
                    if (null == xveUnitOld) {
                        return;
                    }
                    List controllers = modao.getAllSubMo(xveUnitOld.getMoId().longValue(), Controller.class);
                    xveUnitOld.setManageIps(XveUtil.buildManageIPsByControllers(controllers));
                    XveStorage xveStorage = (XveStorage)XveHandlerComm.getInstance().getOldInfo(msg, "storageArray");
                    if (null == xveStorage) {
                        return;
                    }
                    xveStorage.setArrayUnit((ArrayUnit)xveUnitOld);
                    modao.onlyUpdate((ManagedObject)xveUnitOld);
                    modao.onlyUpdate((ManagedObject)xveStorage);
                    this.logger.info((Object)("Manager port Changed managedIps=" + xveStorage.getManagedIps()), 90160777658372L);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveEthPortHandler Exception : XveEthPortHandler report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.ETH_PORT.getValue());
    }

    private void setFromNewToOld(ManagedObject xveHostPortOld, Record xveHostPortNew) {
        if (null != xveHostPortNew && null != xveHostPortOld) {
            if (xveHostPortOld instanceof IscsiHostPort) {
                this.setFormIscsToIscs((IscsiHostPort)xveHostPortOld, xveHostPortNew);
            } else if (xveHostPortOld instanceof ManagementPort) {
                this.setFormMangToMang((ManagementPort)xveHostPortOld, xveHostPortNew);
            }
        }
    }

    private void setFormIscsToIscs(IscsiHostPort iscsiPort, Record record) {
        Integer runningStatus;
        String sasPortId = record.getParamStrValue(XveTLVParent.EthPort.ID.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.EthPort.NAME.getParamIndex());
        Integer healthStatus = V2TypeMapper.ETH_PORT_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.ETH_PORT_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.RUNNINGSTATUS)))) {
            runningStatus = 32;
        }
        Integer speed = TLVParamUtil.getIntValue(record, XveTLVParent.EthPort.SPEED);
        String macAddress = record.getParamStrValue(XveTLVParent.EthPort.MACADDRESS.getParamIndex());
        String bondName = record.getParamStrValue(XveTLVParent.EthPort.BONDNAME.getParamIndex());
        String ipv4Address = record.getParamStrValue(XveTLVParent.EthPort.IPV4ADDR.getParamIndex());
        String ipv4Gateway = record.getParamStrValue(XveTLVParent.EthPort.IPV4GATEWAY.getParamIndex());
        String ipv4Mask = record.getParamStrValue(XveTLVParent.EthPort.IPV4MASK.getParamIndex());
        String ipv6Address = record.getParamStrValue(XveTLVParent.EthPort.IPV6ADDR.getParamIndex());
        String ipv6Mask = record.getParamStrValue(XveTLVParent.EthPort.IPV6MASK.getParamIndex());
        String ipv6Gateway = record.getParamStrValue(XveTLVParent.EthPort.IPV6GATEWAY.getParamIndex());
        String iscsiName = record.getParamStrValue(XveTLVParent.EthPort.ISCSINAME.getParamIndex());
        String location = record.getParamStrValue(XveTLVParent.EthPort.LOCATION.getParamIndex());
        iscsiPort.setName(name);
        iscsiPort.setIpAddress(ipv4Address);
        iscsiPort.setGateway(ipv4Gateway);
        iscsiPort.setMask(ipv4Mask);
        iscsiPort.setIpv6Address(ipv6Address);
        iscsiPort.setIpv6Profix(ipv6Mask);
        iscsiPort.setIpv4Gateway(ipv4Gateway);
        iscsiPort.setIpv4Mask(ipv4Mask);
        iscsiPort.setIpv6Gateway(ipv6Gateway);
        iscsiPort.setIpv6Mask(ipv6Mask);
        if (null != macAddress) {
            macAddress = macAddress.replace(":", "").toLowerCase(Locale.US);
        }
        iscsiPort.setMac(macAddress);
        iscsiPort.setBondName(bondName);
        iscsiPort.setHealthStatus(healthStatus);
        iscsiPort.setRunningStatus(runningStatus);
        iscsiPort.setStatus(healthStatus);
        iscsiPort.setIscsiName(iscsiName);
        iscsiPort.setLocation(location);
        if (null != speed) {
            iscsiPort.setSpeed(Long.valueOf(speed.longValue()));
        }
        try {
            iscsiPort.setPortId(Long.valueOf(sasPortId));
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)nfe.getMessage(), (Throwable)nfe, 90160777658373L);
        }
        iscsiPort.setConnectStatus(runningStatus);
    }

    private void setFormMangToMang(ManagementPort xveHostPortOld, Record record) {
        Integer runningStatus;
        String bondName = record.getParamStrValue(XveTLVParent.EthPort.BONDNAME.getParamIndex());
        String macAddress = record.getParamStrValue(XveTLVParent.EthPort.MACADDRESS.getParamIndex());
        String ipv6Address = record.getParamStrValue(XveTLVParent.EthPort.IPV6ADDR.getParamIndex());
        String ipv6Mask = record.getParamStrValue(XveTLVParent.EthPort.IPV6MASK.getParamIndex());
        String ipv6Gateway = record.getParamStrValue(XveTLVParent.EthPort.IPV6GATEWAY.getParamIndex());
        String ipv4Address = record.getParamStrValue(XveTLVParent.EthPort.IPV4ADDR.getParamIndex());
        String ipv4Gateway = record.getParamStrValue(XveTLVParent.EthPort.IPV4GATEWAY.getParamIndex());
        String ipv4Mask = record.getParamStrValue(XveTLVParent.EthPort.IPV4MASK.getParamIndex());
        String name = record.getParamStrValue(XveTLVParent.EthPort.NAME.getParamIndex());
        Integer healthStatus = V2TypeMapper.ETH_PORT_HEALTH_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.HEALTHSTATUS));
        if (null == healthStatus) {
            healthStatus = 0;
        }
        if (null == (runningStatus = V2TypeMapper.ETH_PORT_RUNNING_STATE.get(TLVParamUtil.getEnumValue(record, XveTLVParent.EthPort.RUNNINGSTATUS)))) {
            runningStatus = 32;
        }
        xveHostPortOld.setHealthStatus(healthStatus);
        xveHostPortOld.setRunningStatus(runningStatus);
        xveHostPortOld.setConnectStatus(runningStatus);
        xveHostPortOld.setStatus(healthStatus);
        xveHostPortOld.setBondName(bondName);
        xveHostPortOld.setIpv6Address(ipv6Address);
        xveHostPortOld.setIpv6Profix(ipv6Mask);
        xveHostPortOld.setIpv4Gateway(ipv4Gateway);
        xveHostPortOld.setIpv4Mask(ipv4Mask);
        xveHostPortOld.setIpv6Gateway(ipv6Gateway);
        xveHostPortOld.setIpv6Mask(ipv6Mask);
        xveHostPortOld.setName(name);
        xveHostPortOld.setIpAddress(ipv4Address);
        if (null != macAddress) {
            macAddress = macAddress.replace(":", "").toLowerCase(Locale.US);
        }
        xveHostPortOld.setMac(macAddress);
    }

    private void getManagerIps(ManagedObject controller) {
        StringBuilder ipsBuffer = new StringBuilder();
        String ips = "";
        if (controller instanceof Controller) {
            IMoDao moDao = CommonDAOLocator.getMoDao();
            List managerPorts = moDao.getAllSubMo(controller.getMoId().longValue(), ManagementPort.class);
            if (VerifyUtil.isEmpty((Collection)managerPorts)) {
                return;
            }
            for (ManagementPort mg : managerPorts) {
                String ip = mg.getIpAddress();
                if (ip == null || ip.length() < 1) continue;
                ipsBuffer.append(ip).append(",");
                if (ipsBuffer.length() <= 0) continue;
                ips = ipsBuffer.substring(0, ipsBuffer.length() - 1);
            }
            ((Controller)controller).setManageIpAddrs(ips);
        }
    }

    private void setControlIpV6(ManagedObject controller) {
        StringBuilder ipsBuffer = new StringBuilder();
        String ips = "";
        if (controller instanceof Controller) {
            IMoDao moDao = CommonDAOLocator.getMoDao();
            List managerPorts = moDao.getAllSubMo(controller.getMoId().longValue(), ManagementPort.class);
            if (VerifyUtil.isEmpty((Collection)managerPorts)) {
                return;
            }
            for (ManagementPort mg : managerPorts) {
                String ip = mg.getIpv6Address();
                if (ip == null || ip.length() < 1) continue;
                ipsBuffer.append(ip).append(",");
                if (ipsBuffer.length() <= 0) continue;
                ips = ipsBuffer.substring(0, ipsBuffer.length() - 1);
            }
            ((Controller)controller).setIpv6Address(ips);
        }
    }
}

