/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveFcInitiatorHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "initiator");
            } else if (reportType == 55847747637L) {
                Initiator initiatorOld = (Initiator)XveHandlerComm.getInstance().getOldInfo(msg, "initiator");
                if (null == initiatorOld) {
                    return;
                }
                Initiator initiatorNew = XveHandlerComm.getInstance().getNewInitiator(msg);
                this.setFromNewToOld(initiatorNew, initiatorOld);
                modao.onlyUpdate((ManagedObject)initiatorOld);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveIscciInitiatorHandler Exception : INITIATOR report error...." + ex + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.FC_INITIATOR.getValue());
    }

    private void setFromNewToOld(Initiator initiatorNew, Initiator initiatorOld) {
        if (null != initiatorNew && null != initiatorOld) {
            initiatorOld.setAlias(initiatorNew.getAlias());
            initiatorOld.setHbaType(initiatorNew.getHbaType());
            initiatorOld.setIdentity(initiatorNew.getIdentity());
            initiatorOld.setHostUUID(initiatorNew.getHostUUID());
            initiatorOld.setName(initiatorNew.getName());
            initiatorOld.setStatus(initiatorNew.getStatus());
            initiatorOld.setHealthStatus(initiatorNew.getHealthStatus());
            initiatorOld.setRunningStatus(initiatorNew.getRunningStatus());
        }
    }
}

