/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveFcPortHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "fcPort");
            } else if (reportType == 55847747637L) {
                FcHostPort xveFcPortOld = (FcHostPort)XveHandlerComm.getInstance().getOldInfo(msg, "fcPort");
                if (null == xveFcPortOld) {
                    return;
                }
                FcHostPort xveFcPortNew = XveHandlerComm.getInstance().getNewFcPort(msg);
                this.setFromNewToOld(xveFcPortNew, xveFcPortOld);
                modao.onlyUpdate((ManagedObject)xveFcPortOld);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveFcPortHandler Exception : fcPort report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.FC_PORT.getValue());
    }

    private void setFromNewToOld(FcHostPort xveFcPortNew, FcHostPort xveFcPortOld) {
        if (null != xveFcPortNew && null != xveFcPortOld) {
            xveFcPortOld.setWwn(xveFcPortNew.getWwn());
            xveFcPortOld.setStatus(xveFcPortNew.getStatus());
            xveFcPortOld.setHealthStatus(xveFcPortNew.getHealthStatus());
            xveFcPortOld.setRunningStatus(xveFcPortNew.getRunningStatus());
            xveFcPortOld.setIntfModuleId(xveFcPortNew.getIntfModuleId());
            xveFcPortOld.setName(xveFcPortNew.getName());
            if (null != xveFcPortNew.getSpeed()) {
                xveFcPortOld.setSpeed(xveFcPortNew.getSpeed());
            }
            xveFcPortOld.setPortId(xveFcPortNew.getPortId());
            xveFcPortOld.setConnectStatus(xveFcPortNew.getConnectStatus());
        }
    }
}

