/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.Chassis;
import com.huawei.ism.array.sdk.model.Controller;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveDisk;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveStorage;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.array.sdk.model.XveTier;
import com.huawei.ism.array.sdk.model.XveUnit;
import com.huawei.ism.base.port.sdk.model.FcHostPort;
import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.array.ComputeArrayColumn;
import com.huawei.ism.cbb.discover.service.impl.XveDeviceProxyImpl;
import com.huawei.ism.cbb.discover.xve.XveTLVTransition;
import com.huawei.ism.cbb.discover.xve.handler.TransactionCallbackImpl;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.proxy.xve.TLVParamUtil;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.proxy.xve.XveTLV;
import com.huawei.ism.cbb.proxy.xve.XveTLVPParent;
import com.huawei.ism.cbb.proxy.xve.XveUUID;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.cbb.util.unit.IUnitType;
import com.huawei.ism.cbb.util.unit.UnitConvert;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hibernate.query.NativeQuery;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.support.TransactionCallback;

public class XveHandlerComm {
    private static Log logger = LogFactory.getInstance(XveHandlerComm.class, (String)"UBase/Xve_Discover");
    private static XveHandlerComm instance;

    public static synchronized XveHandlerComm getInstance() {
        if (null == instance) {
            logger.info((Object)"Initialize XveHandlerComm");
            instance = new XveHandlerComm();
        }
        return instance;
    }

    private String getUuId(Notification msg, String type) {
        String uuId;
        String deviceID = (String)msg.getAttribute("deviceID");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        if ("storageArray".equals(type)) {
            uuId = "XveStorage" + new XveUUID(deviceID, XveMOType.SYSTEM.getValue(), "");
        } else if ("xveUnit".equals(type)) {
            uuId = new XveUUID(deviceID, XveMOType.SYSTEM.getValue(), "").toString();
        } else if ("initiator".equals(type)) {
            if (null == idValue) {
                logger.error((Object)"idValue is null.");
                throw new LegoCheckedException(1073947393L);
            }
            uuId = new XveUUID(deviceID, typeValue.intValue(), String.valueOf(idValue.hashCode())).toString();
        } else {
            uuId = new XveUUID(deviceID, typeValue.intValue(), idValue).toString();
        }
        return uuId;
    }

    public void deleteMoByMsg(Notification msg, String type) {
        if (null == msg || null == type) {
            logger.debug((Object)("msg:" + msg));
            return;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        logger.info((Object)("Delete " + type + "...."), 90160777658372L);
        try {
            TransactionCallbackImpl callBack = new TransactionCallbackImpl(moDao, this.getUuId(msg, type));
            moDao.getTransactionTemplate().execute((TransactionCallback)callBack);
        }
        catch (Exception ex) {
            logger.error((Object)("Delete " + type + " error ...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    public ManagedObject getOldInfo(Notification msg, String type) {
        ManagedObject oldInfo;
        if (null == msg || null == type) {
            logger.debug((Object)("type:" + type));
            return null;
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        try {
            oldInfo = moDao.getMoByUuid(this.getUuId(msg, type), Boolean.valueOf(true));
        }
        catch (Exception ex) {
            logger.error((Object)("Get device info from db by UUID error.Error info" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            oldInfo = null;
        }
        return oldInfo;
    }

    protected XveUnit getNewXveUnit(Notification msg) {
        XveUnit xveUnitNew;
        if (null == msg) {
            return null;
        }
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        try {
            xveUnitNew = xveDeviceProxy.getComputerSystem(connection);
        }
        catch (Exception ex) {
            logger.error((Object)("Get storage info error.Error info" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
            xveUnitNew = null;
        }
        return xveUnitNew;
    }

    protected XveDisk getNewDisks(Notification msg) {
        XveDisk xveDisk;
        if (null == msg) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (null == connection) {
            logger.error((Object)"connection is null.");
            return null;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        if (null == typeValue) {
            logger.error((Object)"typeValue is null.");
            return null;
        }
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            xveDisk = XveTLVTransition.transitionXveDisk(deviceID, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            xveDisk = null;
        }
        return xveDisk;
    }

    protected XveStoragePool getNewStoragePool(Notification msg) {
        XveStoragePool xveStoragePool;
        if (null == msg) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (null == connection) {
            logger.error((Object)"connection is null.");
            return null;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        if (null == typeValue) {
            logger.error((Object)"typeValue is null.");
            return null;
        }
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            xveStoragePool = XveTLVTransition.transitionXveStoragePool(deviceID, record);
            TimeUnit.SECONDS.sleep(1L);
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param(XveTLV.StorageTier.PARENTID.getParamIndex(), XveTLV.StorageTier.PARENTID.getParamType(), xveStoragePool.getPoolId()));
            List tierRecords = connection.pmGetBacthNext(XveMOType.STORAGETIER.getValue(), params, 30);
            for (Record tierRecord : tierRecords) {
                XveTier xveTier = XveTLVTransition.transitionXveTier(deviceID, tierRecord);
                String poolId = xveTier.getPoolId();
                String tierId = xveTier.getTierId();
                if (tierId.equals(poolId + ".0")) {
                    xveStoragePool.setTier0FreeCapacity(xveTier.getTierAvailableCapacity());
                    xveStoragePool.setTier0UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                if (tierId.equals(poolId + ".1")) {
                    xveStoragePool.setTier1FreeCapacity(xveTier.getTierAvailableCapacity());
                    xveStoragePool.setTier1UsedCapacity(xveTier.getTierConsumedCapacity());
                }
                if (!tierId.equals(poolId + ".2")) continue;
                xveStoragePool.setTier2FreeCapacity(xveTier.getTierAvailableCapacity());
                xveStoragePool.setTier2UsedCapacity(xveTier.getTierConsumedCapacity());
            }
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            xveStoragePool = null;
        }
        return xveStoragePool;
    }

    protected XveLun getNewLuns(Notification msg) {
        XveLun lun;
        if (null == msg) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (null == connection) {
            logger.error((Object)"connection is null.");
            return null;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        if (null == typeValue) {
            logger.error((Object)"typeValue is null.");
            return null;
        }
        String idValue = (String)msg.getAttribute("idValue");
        String devSn = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            lun = XveDeviceProxyImpl.parseLun(devSn, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            lun = null;
        }
        return lun;
    }

    protected Controller getNewController(Notification msg) {
        Controller controller;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            controller = XveDeviceProxyImpl.parseController(deviceID, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            controller = null;
        }
        return controller;
    }

    private boolean checkPara(Notification msg) {
        if (null == msg) {
            logger.error((Object)"msg is null.");
            return false;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (null == connection) {
            logger.error((Object)"connection is null.");
            return false;
        }
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        if (null == typeValue) {
            logger.error((Object)"typeValue is null.");
            return false;
        }
        return true;
    }

    protected Record getNewHostPort(Notification msg) {
        Record record;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        try {
            record = connection.pmGet(typeValue.intValue(), idValue, 30);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            record = null;
        }
        return record;
    }

    protected FcHostPort getNewFcPort(Notification msg) {
        FcHostPort fcPort;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            fcPort = XveDeviceProxyImpl.parseFcPort(deviceID, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            fcPort = null;
        }
        return fcPort;
    }

    protected SasHostPort getNewSasPort(Notification msg) {
        SasHostPort sasPort;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String devSn = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            sasPort = XveDeviceProxyImpl.parseSasPort(devSn, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            sasPort = null;
        }
        return sasPort;
    }

    protected List<Chassis> getNewChassis(Notification msg) {
        List<Chassis> chassis;
        if (null == msg) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        XveDeviceProxyImpl xveDeviceProxy = new XveDeviceProxyImpl();
        try {
            chassis = xveDeviceProxy.getChassises(connection, this.getNewXveUnit(msg));
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            chassis = null;
        }
        return chassis;
    }

    protected MappingView getNewMappingView(Notification msg) {
        MappingView mappingView;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            if (null == record) {
                logger.error((Object)"record is null.");
                return null;
            }
            String mappingViewId = record.getParamStrValue(XveTLV.MappingView.ID.getParamIndex());
            String name = record.getParamStrValue(XveTLV.MappingView.NAME.getParamIndex());
            String description = record.getParamStrValue(XveTLV.MappingView.DESCRIPTION.getParamIndex());
            mappingView = new MappingView();
            mappingView.setUuid(new XveUUID(deviceID, XveMOType.MAPPINGVIEW, mappingViewId).toString());
            mappingView.setMappingViewId(mappingViewId);
            mappingView.setName(name);
            mappingView.setDescription(description);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            mappingView = null;
        }
        return mappingView;
    }

    protected ArrayHost getNewArrayHost(Notification msg) {
        ArrayHost arrayHost;
        if (!this.checkPara(msg)) {
            return null;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            arrayHost = XveTLVTransition.transitionArrayHost(deviceID, record);
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
            arrayHost = null;
        }
        return arrayHost;
    }

    protected Initiator getNewInitiator(Notification msg) {
        if (!this.checkPara(msg)) {
            return null;
        }
        Initiator initiator = null;
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        Integer typeValue = (Integer)msg.getAttribute("typeValue");
        String idValue = (String)msg.getAttribute("idValue");
        String deviceID = (String)msg.getAttribute("deviceID");
        try {
            Record record = connection.pmGet(typeValue.intValue(), idValue, 30);
            if (typeValue.intValue() == XveMOType.FC_INITIATOR.getValue()) {
                initiator = XveDeviceProxyImpl.getFcInitiatorInfo(record, deviceID);
            } else if (typeValue.intValue() == XveMOType.ISCSI_INITIATOR.getValue()) {
                initiator = XveDeviceProxyImpl.getIscsiInitiatorInfo(record, deviceID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)ex));
        }
        return initiator;
    }

    protected void setOwnTieAndSave(ManagedObject son, Notification msg) {
        if (null == msg || null == son) {
            return;
        }
        try {
            ManagedObject father;
            IMoDao moDao = CommonDAOLocator.getMoDao();
            if (son instanceof XveLun) {
                XveUUID uuId = new XveUUID((String)msg.getAttribute("deviceID"), XveMOType.STORAGEPOOL.getValue(), ((XveLun)son).getStoragePoolId());
                father = moDao.getMoByUuid(uuId.toString(), Boolean.valueOf(true));
            } else {
                father = this.getOldInfo(msg, "xveUnit");
            }
            if (null != father) {
                this.setManager(father, son);
                son.setParentMo(father);
                son.setTopMoUuid(father.getTopMoUuid());
                moDao.save((Object)son);
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Save the create report error ..." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    private void setManager(ManagedObject father, ManagedObject son) {
        if (son instanceof XveStoragePool) {
            ((XveStoragePool)son).setNeSN(((XveUnit)father).getDevSn());
        }
    }

    protected void setLunCapacity(Notification msg) {
        if (null == msg) {
            return;
        }
        String deviceID = (String)msg.getAttribute("deviceID");
        IMoDao moDao = CommonDAOLocator.getMoDao();
        XveUnit xveUnit = (XveUnit)moDao.getMo(XveUnit.class, "devSn", (Object)deviceID);
        if (null == xveUnit) {
            logger.error((Object)"Can NOT find the top array of given LUN  !!! ", 90160777658373L);
            return;
        }
        ComputeArrayColumn.LunCap lunCap = ComputeArrayColumn.computeLunCap(deviceID);
        HibernateTemplate template = moDao.getHibernateTemplate();
        template.execute(session -> {
            String hql = "update ti_arrayunit t set t.TOTALLUNCAP=?, t.MAPPEDLUNCAP=? where t.MOID=?";
            NativeQuery query = session.createSQLQuery(hql);
            query.setDouble(0, lunCap.getTotalLunCap());
            query.setDouble(1, lunCap.getMappedLunCap());
            query.setLong(2, xveUnit.getMoId().longValue());
            query.executeUpdate();
            hql = "update ti_storagearray t set t.TOTALLUNCAP=?, t.MAPPEDLUNCAP=? where t.MOID=?";
            query = session.createSQLQuery(hql);
            query.setDouble(0, lunCap.getTotalLunCap());
            query.setDouble(1, lunCap.getMappedLunCap());
            query.setLong(2, xveUnit.getParentId().longValue());
            query.executeUpdate();
            return null;
        });
    }

    protected void getTv2Capacity(Notification msg) {
        if (null == msg) {
            return;
        }
        TLVConnection connection = (TLVConnection)msg.getAttribute("conn");
        if (null == connection) {
            return;
        }
        try {
            Record record = connection.pmGet(XveMOType.SYSTEM.getValue(), "", 30);
            XveUnit xveUnit = (XveUnit)this.getOldInfo(msg, "xveUnit");
            if (null == xveUnit) {
                return;
            }
            Double memberDisksCapacity = TLVParamUtil.getDoubleValue(record, XveTLVPParent.System.MEMBERDISKSCAPACITY);
            Double freeDisksCapacity = TLVParamUtil.getDoubleValue(record, XveTLVPParent.System.FREEDISKSCAPACITY);
            Integer sectorSize = TLVParamUtil.getIntValue(record, XveTLVPParent.System.SECTORSIZE);
            if (null != memberDisksCapacity && null != freeDisksCapacity && null != sectorSize) {
                double totalCapacity = UnitConvert.convert((Double)((memberDisksCapacity + freeDisksCapacity) * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.GB);
                double usedCapacity = UnitConvert.convert((Double)(memberDisksCapacity * (double)sectorSize.intValue()), (IUnitType)CapabilityUnitType.BYTE, (IUnitType)CapabilityUnitType.GB);
                IMoDao moDao = CommonDAOLocator.getMoDao();
                HibernateTemplate template = moDao.getHibernateTemplate();
                template.execute(session -> {
                    String hql = "update ti_storageunit t set t.TOTALCAPACITY=?, t.USEDCAPACITY=? where t.MOID=?";
                    NativeQuery query = session.createSQLQuery(hql);
                    query.setDouble(0, totalCapacity);
                    query.setDouble(1, usedCapacity);
                    query.setLong(2, xveUnit.getMoId().longValue());
                    query.executeUpdate();
                    hql = "update ti_storagene t set t.TOTALCAPACITY=?, t.USEDCAPACITY=? where t.MOID=?";
                    query = session.createSQLQuery(hql);
                    query.setDouble(0, totalCapacity);
                    query.setDouble(1, usedCapacity);
                    query.setLong(2, xveUnit.getParentId().longValue());
                    query.executeUpdate();
                    return null;
                });
                XveStorage oldXveStorage = new XveStorage();
                oldXveStorage.setTotalCapacity(xveUnit.getTotalCapacity());
                XveStorage newXveStorage = (XveStorage)xveUnit.getParentMo();
                newXveStorage.setTotalCapacity(Double.valueOf(totalCapacity));
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Update Array Capacity info Error." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }
}

