/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveHostHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "arrayHost");
            } else if (reportType == 55847747637L) {
                ArrayHost arrayHostOld = (ArrayHost)XveHandlerComm.getInstance().getOldInfo(msg, "arrayHost");
                if (null == arrayHostOld) {
                    return;
                }
                ArrayHost arrayHostNew = XveHandlerComm.getInstance().getNewArrayHost(msg);
                this.setFromNewToOld(arrayHostNew, arrayHostOld);
                modao.onlyUpdate((ManagedObject)arrayHostOld);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveHostHandler Exception : XveHostHandler report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.HOST.getValue());
    }

    private void setFromNewToOld(ArrayHost arrayHostNew, ArrayHost arrayHostOld) {
        if (null != arrayHostNew && null != arrayHostOld) {
            arrayHostOld.setName(arrayHostNew.getName());
            arrayHostOld.setHostId(arrayHostNew.getHostId());
            arrayHostOld.setOs(arrayHostNew.getOs());
            arrayHostOld.setHostGroupUuid(arrayHostNew.getHostGroupUuid());
            arrayHostOld.setStatus(arrayHostNew.getStatus());
            arrayHostOld.setHealthStatus(arrayHostNew.getHealthStatus());
            arrayHostOld.setRunningStatus(arrayHostNew.getRunningStatus());
            arrayHostOld.setDescription(arrayHostNew.getDescription());
            arrayHostOld.setIpAddress(arrayHostNew.getIpAddress());
            arrayHostOld.setModel(arrayHostNew.getModel());
            arrayHostOld.setLocation(arrayHostNew.getLocation());
        }
    }
}

