/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveLunHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "xveLun");
                XveHandlerComm.getInstance().setLunCapacity(msg);
            } else if (reportType == 55847747637L) {
                XveLun xveLunOld = (XveLun)XveHandlerComm.getInstance().getOldInfo(msg, "");
                if (null == xveLunOld) {
                    return;
                }
                XveLun xveLunNew = XveHandlerComm.getInstance().getNewLuns(msg);
                this.setFromNewToOld(xveLunNew, xveLunOld);
                modao.onlyUpdate((ManagedObject)xveLunOld);
                XveHandlerComm.getInstance().setLunCapacity(msg);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveLunHandler Exception : lun report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.LUN.getValue());
    }

    private void setFromNewToOld(XveLun xveLunNew, XveLun xveLunOld) {
        if (null != xveLunNew && null != xveLunOld) {
            xveLunOld.setLunId(xveLunNew.getLunId());
            xveLunOld.setStoragePoolId(xveLunNew.getStoragePoolId());
            xveLunOld.setDevSn(xveLunNew.getDevSn());
            xveLunOld.setName(xveLunNew.getName());
            xveLunOld.setTotalCapacity(xveLunNew.getTotalCapacity());
            xveLunOld.setTotalCapacityUnit(xveLunNew.getTotalCapacityUnit());
            xveLunOld.setStatus(xveLunNew.getStatus());
            xveLunOld.setRunningStatus(xveLunNew.getRunningStatus());
            xveLunOld.setHealthStatus(xveLunNew.getHealthStatus());
            xveLunOld.setDataDistributing(xveLunNew.getDataDistributing());
            xveLunOld.setDataTransferPolicy(xveLunNew.getDataTransferPolicy());
            xveLunOld.setWwn(xveLunNew.getWwn());
            xveLunOld.setLunType(xveLunNew.getLunType());
            xveLunOld.setMapped(xveLunNew.getMapped());
            xveLunOld.setControllerId(xveLunNew.getControllerId());
        }
    }
}

