/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveMappingViewHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "mappingView");
            } else if (reportType == 55847747637L) {
                MappingView mappingViewOld = (MappingView)XveHandlerComm.getInstance().getOldInfo(msg, "mappingView");
                if (null == mappingViewOld) {
                    return;
                }
                MappingView mappingViewNew = XveHandlerComm.getInstance().getNewMappingView(msg);
                this.setFromNewToOld(mappingViewNew, mappingViewOld);
                modao.onlyUpdate((ManagedObject)mappingViewOld);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveMappingViewHandler Exception : MappingView report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.MAPPINGVIEW.getValue());
    }

    private void setFromNewToOld(MappingView mappingViewNew, MappingView mappingViewOld) {
        if (null != mappingViewNew && null != mappingViewOld) {
            mappingViewOld.setName(mappingViewNew.getName());
            mappingViewOld.setDescription(mappingViewNew.getDescription());
        }
    }
}

