/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.handler;

import com.huawei.ism.base.port.sdk.model.SasHostPort;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.IHandler;
import com.huawei.ism.cbb.discover.xve.handler.XveHandlerComm;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;

public class XveSasPortHandler
implements IHandler {
    private final Log logger = LogFactory.getInstance((Object)this, (String)"UBase/Xve_Discover");

    @Override
    public void handle(Notification msg) {
        if (null == msg) {
            return;
        }
        try {
            IMoDao modao = CommonDAOLocator.getMoDao();
            Long reportType = (Long)msg.getAttribute("reportType");
            if (reportType == 55847747638L) {
                XveHandlerComm.getInstance().deleteMoByMsg(msg, "sasPort");
            } else if (reportType == 55847747637L) {
                SasHostPort xveSasPortOld = (SasHostPort)XveHandlerComm.getInstance().getOldInfo(msg, "sasPort");
                if (null == xveSasPortOld) {
                    return;
                }
                SasHostPort xveSasPortNew = XveHandlerComm.getInstance().getNewSasPort(msg);
                this.setFromNewToOld(xveSasPortNew, xveSasPortOld);
                modao.onlyUpdate((ManagedObject)xveSasPortOld);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("XveSasPortHandler Exception : sasPort report error...." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658373L);
        }
    }

    @Override
    public String handleType() {
        return String.valueOf(XveMOType.SAS_PORT.getValue());
    }

    private void setFromNewToOld(SasHostPort xveSasPortNew, SasHostPort xveSasPortOld) {
        if (null != xveSasPortNew && null != xveSasPortOld) {
            xveSasPortOld.setWwn(xveSasPortNew.getWwn());
            xveSasPortOld.setStatus(xveSasPortNew.getStatus());
            xveSasPortOld.setHealthStatus(xveSasPortNew.getHealthStatus());
            xveSasPortOld.setRunningStatus(xveSasPortNew.getRunningStatus());
            xveSasPortOld.setIntfModuleId(xveSasPortNew.getIntfModuleId());
            xveSasPortOld.setSpeed(xveSasPortNew.getSpeed());
            xveSasPortOld.setName(xveSasPortNew.getName());
            xveSasPortOld.setPortId(xveSasPortNew.getPortId());
            xveSasPortOld.setConnectStatus(xveSasPortNew.getConnectStatus());
        }
    }
}

