/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.discover.xve.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.process.AbstractPingProcessor;
import com.huawei.ism.cbb.discover.xve.XveUtil;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.ConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.IConnection;
import com.huawei.ism.cbb.proxy.protocol.tlv.connection.TLVConnection;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Properties;

public class XvePingProcessor
extends AbstractPingProcessor {
    private final Log logger = LogFactory.getInstance(XvePingProcessor.class, (String)"UBase/Xve_Discover");

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getCurrentIp(String sn) {
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().getConnection(sn);
        if (XveUtil.socketIsNomal(connection)) {
            this.logger.debug((Object)("XVE ping success, devSn=" + sn + ", ip=" + connection.getUrl()));
            return connection.getUrl();
        }
        return null;
    }

    protected void connect(String sn, String ip, NeMgrProtocolExtend info) {
        Properties properties = new Properties();
        properties.put("USER_NAME", info.getNetworkUserName());
        properties.put("PASSWORD", info.getNetworkPassword());
        properties.put("USERSCOPE", "0");
        properties.put("PORT", "8080");
        properties.put("CONN_PROTOCOL", (Object)1);
        properties.put("IP_OR_NAME", ip);
        TLVConnection connection = (TLVConnection)ConnectionManager.getInstance().buildConnection(DeviceType.C3.name(), properties);
        connection.authenticate();
        ConnectionManager.getInstance().setConnection(sn, (IConnection)connection);
    }
}

