/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.mediation.status;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.util.NetUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;

public class DefaultRegisterTrapFailStatus
implements Istatus {
    private int registSuccess = 0;
    private final boolean firstTime = true;
    private final Log logger = LogFactory.getInstance((Object)this);

    public void doAction(ManagedObject entity, int status) {
        IAlarmService alarmservice = (IAlarmService)ServiceContext.getInstance().lookup("fault/alarmService");
        ManagedObject mo = entity.getParentMo();
        if (null == mo) {
            mo = entity;
        }
        String id = mo.getMoId() + "0xE012C0011";
        LegoAlarm oldAlarm = null;
        try {
            oldAlarm = alarmservice.getUnclearedAlarm("0xE012C0011", mo.getMoId());
        }
        catch (Exception e) {
            this.logger.info((Object)("Cannot find Alarm by alarmId : " + id), 90160777658901L);
        }
        int trapPort = alarmservice.getTrapPort();
        if (status == 1 && null == oldAlarm) {
            this.sendAlarm(entity, id, trapPort);
        }
        if (null != oldAlarm && status == 1 && oldAlarm.getClearStatus() == FaultEnum.ClearState.CLEARED) {
            this.sendAlarm(entity, id, trapPort);
        } else if (null != oldAlarm && status == 0 && oldAlarm.getClearStatus() == FaultEnum.ClearState.UNCLEARED) {
            this.sendRestoreAlarm(entity, oldAlarm, trapPort);
        }
        this.setRegistSuccess(status);
    }

    private String getLinkIp(ManagedObject mo) {
        if (mo instanceof NetworkEntity) {
            return ((NetworkEntity)mo).getLinkIp();
        }
        if (mo instanceof StorageUnit) {
            return ((StorageUnit)mo).getLinkIp();
        }
        return "";
    }

    public int getRegistSuccess() {
        return this.registSuccess;
    }

    public boolean isFirstTime() {
        return true;
    }

    private void sendAlarm(ManagedObject entity, String id, int port) {
        LegoAlarm alarm = new LegoAlarm();
        ManagedObject parent = entity.getParentMo();
        alarm.setMoId(parent.getMoId().longValue());
        String linkIp = this.getLinkIp(parent);
        alarm.setMoIP(linkIp);
        alarm.setMoName(parent.getName());
        alarm.setMoUuid(parent.getUuid());
        alarm.setAlarmId("0xE012C0011");
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmLevel(FaultEnum.AlarmSeverity.MAJOR);
        String ip = this.getLocalIPFromV1(linkIp);
        String[] alramParams = new String[]{ip, String.valueOf(port), entity.getName()};
        alarm.setAlarmParam(alramParams);
        alarm.setEntity(id);
        alarm.setClearStatus(FaultEnum.ClearState.UNCLEARED);
        alarm.setSourceId(entity.getUuid());
        alarm.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        this.logger.info((Object)("Alarm : Send register trapip failed alarm,from resourse:" + linkIp), 90160758784518L);
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateAlarm(alarm);
    }

    private void sendRestoreAlarm(ManagedObject entity, LegoAlarm oldalarm, int trapPort) {
        LegoAlarm alarm = new LegoAlarm();
        ManagedObject parent = entity.getParentMo();
        alarm.setMoId(parent.getMoId().longValue());
        String linkIp = this.getLinkIp(parent);
        alarm.setMoIP(linkIp);
        alarm.setMoName(parent.getName());
        alarm.setMoUuid(parent.getUuid());
        alarm.setAlarmId("0xE012C0011");
        alarm.setAlarmLevel(FaultEnum.AlarmSeverity.MAJOR);
        String ip = this.getLocalIPFromV1(linkIp);
        String[] alramParams = new String[]{ip, String.valueOf(trapPort), entity.getName()};
        alarm.setSourceId(entity.getUuid());
        alarm.setSourceType(FaultEnum.AlarmResourceType.NETWORKENTITY.getValue());
        alarm.setAlarmParam(alramParams);
        alarm.setEntity(oldalarm.getEntity());
        alarm.setAlarmTime(oldalarm.getAlarmTime());
        alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
        alarm.setClearTime(System.currentTimeMillis());
        alarm.setClearUser("system");
        this.logger.info((Object)("Alarm : Send register trapip resume alarm,from resourse:" + linkIp), 90160758784517L);
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateRestoreAlarm(alarm);
    }

    public void setRegistSuccess(int registSuccess) {
        this.registSuccess = registSuccess;
    }

    private String getLocalIPFromV1(String linkIp) {
        String ip = NetUtil.getLocalIP((String)linkIp, (DeviceContext.ProtocalType)DeviceContext.ProtocalType.HTTP);
        if (ip == null) {
            ip = NetUtil.getLocalIP((String)linkIp, (DeviceContext.ProtocalType)DeviceContext.ProtocalType.HTTPS);
        }
        if (ip == null) {
            ip = "";
        }
        return ip;
    }
}

