/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.indication;

import com.huawei.ism.connection.smis.CIMListenerImpl;
import com.huawei.ism.notification.NotificationManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMEvent;

public class CIMIndicationListenerImpl
extends CIMListenerImpl {
    private static Log logger = LogFactory.getInstance(CIMIndicationListenerImpl.class);
    private String deviceID = "";

    public CIMIndicationListenerImpl(String deviceID) {
        super(deviceID);
        this.deviceID = deviceID;
    }

    public void indicationOccured(CIMEvent event) {
        try {
            CIMInstance indicationInstance = event.getIndication();
            String className = indicationInstance.getClassName();
            if ("ISM_AlertIndication".equals(className) || "ISM_HistoryAlertIndication".equals(className)) {
                return;
            }
            CIMProperty arrayIdProperty = indicationInstance.getProperty("SourceInstanceHost");
            if (!this.deviceID.equals(this.getValueFromProperty(arrayIdProperty))) {
                return;
            }
            NotificationManager.getInstance().putInChangeQueue(this.deviceID, indicationInstance);
        }
        catch (Exception t) {
            logger.error((Object)("indicationOccured event = " + event), 90160777658880L);
        }
    }

    private Object getValueFromProperty(CIMProperty property) {
        Object value = null;
        if (null != property && null != property.getValue()) {
            value = property.getValue().getValue();
        }
        return value;
    }
}

