/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.indication;

import com.huawei.ism.cbb.proxy.indication.IIndicationMonitor;
import com.huawei.ism.cbb.proxy.indication.IIndicationWatcher;
import com.huawei.ism.cbb.proxy.indication.ISubscription;
import com.huawei.ism.cbb.proxy.indication.Notification;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.connection.smis.ConnectionManager;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.notification.IChangeTaker;
import com.huawei.ism.notification.NotificationManager;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.wbem.cim.CIMInstance;

public final class IndicationMonitor
implements IIndicationMonitor,
IChangeTaker {
    private static IndicationMonitor monitor = new IndicationMonitor();
    private final Log logger = LogFactory.getInstance((Object)this);
    private final Map<String, ISubscription> subscriptions = new ConcurrentHashMap<String, ISubscription>();
    private IIndicationWatcher indicationWatcher;

    private IndicationMonitor() {
    }

    public static IndicationMonitor getMonitor() {
        return monitor;
    }

    public static IndicationMonitor getMonitor(IIndicationWatcher watcher) {
        if (watcher == null) {
            throw new IllegalArgumentException("The indication monitor need a watcher !");
        }
        IndicationMonitor.monitor.indicationWatcher = watcher;
        return monitor;
    }

    public void notifyIndication(Connection con, CIMInstance cins, String type) {
        this.logger.debug((Object)("Received device trap message : " + type + ",instance : " + cins.getClassName()));
        if (!this.indicationWatcher.watchCim(type)) {
            return;
        }
        String deviceId = con.getArrayId();
        Set<ISubscription> tmpSubscriptions = this.getAllOrdersByDeviceId(deviceId);
        Notification notification = new Notification(con, cins, type);
        for (ISubscription subscription : tmpSubscriptions) {
            subscription.notifyMsg(notification);
        }
    }

    public synchronized void notifyIsm(Object obj) {
        if (!(obj instanceof IsmMsg)) {
            this.logger.info((Object)"Reject a non-IsmMsg object ", 90160777658901L);
            return;
        }
        IsmMsg msg = (IsmMsg)obj;
        String msgType = msg.getMsgType();
        this.logger.debug((Object)"Received ism message ", 90160777658901L);
        if (!this.indicationWatcher.watchIsm(msgType)) {
            return;
        }
        String deviceId = (String)msg.getProperty((Object)"DEVICE_ID");
        ISubscription subscription = this.subscriptions.get(deviceId);
        if (subscription != null) {
            Notification notification = new Notification(null, null, msgType);
            notification.setAttribute("device.entityobject", msg);
            subscription.notifyMsg(notification);
        }
    }

    @Override
    public synchronized void addSubscription(ISubscription order) {
        if (order == null) {
            this.logger.error((Object)"Null subscription object !!!", 90160758784004L);
            return;
        }
        String deviceId = order.getDeviceId();
        if (!this.subscriptions.containsKey(deviceId)) {
            this.subscriptions.put(deviceId, order);
        }
        this.subscriptionAgent(deviceId);
    }

    @Override
    public synchronized void removeSubscriptionByDeviceId(String deviceId) {
        if (deviceId != null && deviceId.length() > 0) {
            this.subscriptions.remove(deviceId);
            this.unSubscriptionAgent(deviceId);
        }
    }

    private synchronized Set<ISubscription> getAllOrdersByDeviceId(String deviceId) {
        HashSet<ISubscription> orderList = new HashSet<ISubscription>();
        ISubscription order = this.subscriptions.get(deviceId);
        if (null != order) {
            orderList.add(order);
        }
        return orderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriptionAgent(String deviceId) {
        NotificationManager manager = NotificationManager.getInstance();
        try {
            NotificationManager.getInstance().loadSubscriptTypes(deviceId, new NotificationManager.SubscriptType[]{NotificationManager.SubscriptType.ALL});
            Connection connection = ConnectionManager.getInstance().getConnectionByArrayId(deviceId);
            manager.subscription(connection);
        }
        catch (Exception e) {
            this.logger.error((Object)("Subscript Agent Error, deviceId : " + deviceId + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658880L);
        }
        finally {
            manager.addProcessor(deviceId, (IChangeTaker)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unSubscriptionAgent(String deviceId) {
        NotificationManager manager = NotificationManager.getInstance();
        try {
            if (ConnectionManager.getInstance().isExistConnection(deviceId)) {
                Connection connection = ConnectionManager.getInstance().getConnectionByArrayId(deviceId);
                manager.deleteSubscriptionOfOneArray(connection);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
        }
        finally {
            manager.removeProcessor(deviceId);
        }
    }

    @Override
    public synchronized boolean isRegistered(String deviceId) {
        ISubscription subs = this.subscriptions.get(deviceId);
        return subs != null;
    }
}

