/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.base;

import com.huawei.ism.cbb.proxy.protocol.base.ConnectionEvent;
import com.huawei.ism.cbb.proxy.protocol.base.IConnection;
import com.huawei.ism.cbb.proxy.protocol.base.IConnectionListener;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.wbem.cim.CIMException;

public abstract class BaseConnection
implements IConnection {
    private String host;
    private String password;
    private int port;
    private String protocol;
    private String userName;
    private boolean connected = false;
    private String connectionId;
    private final Set<IConnectionListener> listeners = new HashSet<IConnectionListener>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean valid = false;

    protected BaseConnection() {
    }

    public BaseConnection(Properties connProperties) throws CIMException {
        this.init(connProperties);
    }

    @Override
    public void addListener(IConnectionListener l) {
        Lock ll = this.lock.writeLock();
        try {
            ll.lock();
            this.listeners.add(l);
        }
        finally {
            ll.unlock();
        }
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    protected abstract void init(Properties var1) throws CIMException;

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void notifyListener(ConnectionEvent connEvent) {
        for (IConnectionListener listener : this.listeners) {
            listener.stateChanged(connEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(IConnectionListener l) {
        Lock ll = this.lock.writeLock();
        try {
            ll.lock();
            boolean bl = this.listeners.remove(l);
            return bl;
        }
        finally {
            ll.unlock();
        }
    }

    @Override
    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

