/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest;

import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.util.BufferedReaderDecorator;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.ism.util.CommonUtil;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public final class RestClient {
    private static Log logger = LogFactory.getInstance(RestClient.class);
    private static final int DEFAULT_VALUE_10 = 10;
    private static final int DEFAULT_VALUE_30 = 30;
    private static final int DEFAULT_VALUE_1000 = 1000;
    private static final int DEFAULT_VALUE_60 = 60;
    private static final int CONNECT_TIMEOUT = 30000;
    private static final int READDATA_TIMEOUT = 1800000;
    private static final int MAX_RETRY_TIME = 3;
    private static final long NEED_RETRY_TIME = 600000L;
    private static final String TLSV1_2 = "TLSv1.2";

    public static CloseableHttpClient buildHttpClient(String ip) {
        SSLContext context;
        try {
            context = SSLContext.getInstance("TLS");
            context.init(null, new TrustManager[]{new BcmX509TrustManager(ip)}, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (Exception e) {
            throw new LegoCheckedException(-1L, "create SSL context fail,ipAddress:" + ip + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        String[] supportedProtocols = new String[]{TLSV1_2};
        String supportedProtocolConfig = LegoConfig.getInstance().getKeyValue("SUPPORT_TLS_PROTOCLO_VERSIONS");
        if (!VerifyUtil.isEmpty((String)supportedProtocolConfig)) {
            supportedProtocols = supportedProtocolConfig.split(",");
        }
        SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, supportedProtocols, null, (HostnameVerifier)new NoopHostnameVerifier());
        Registry registry = RegistryBuilder.create().register("https", (Object)sslFactory).build();
        PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager(registry);
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setConnectTimeout(Timeout.ofMilliseconds((long)30000L));
        builder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)1800000L));
        RequestConfig requestConfig = builder.build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connMgr).disableContentCompression().build();
    }

    public static RestResponseData processRequest(CloseableHttpClient httpclient, RestRequestData request) {
        logger.debug((Object)"Enter processRequest.");
        if (null == httpclient || null == request) {
            logger.error((Object)"null parameter.");
            throw new LegoCheckedException(1073947393L);
        }
        RestResponseData restResponse = new RestResponseData();
        String url = request.getUri();
        String method = request.getRequestMethod();
        ClassicHttpRequest httpRequest = null;
        int retryTimes = 0;
        while (retryTimes < 3) {
            long requestBegin = new Date().getTime();
            try {
                httpRequest = RestClient.buildHttpRequest(method, url, request);
                RestClient.setHttpHeaders(request, httpRequest);
                CloseableHttpResponse response = httpclient.execute(httpRequest);
                RestClient.receiveResponse(restResponse, response);
                logger.debug((Object)"ProcessRequest success");
                break;
            }
            catch (UnsupportedEncodingException ue) {
                logger.error((Object)("UnsupportedEncodingException, method=" + method + ", url=" + url), (Throwable)ue);
                throw new LegoCheckedException(1073947393L, (Throwable)ue);
            }
            catch (IOException ie) {
                logger.error((Object)("IOEx, method=" + method + ", url=" + url + ", retryTimes=" + retryTimes), (Throwable)ie);
                long requestEnd = new Date().getTime();
                logger.error((Object)("IOEx, method=" + method + ", url=" + url + ", time=" + (requestEnd - requestBegin)));
                if (++retryTimes < 3 && requestEnd - requestBegin <= 600000L) continue;
                logger.info((Object)"Process request fail, cause by timeout, url = %s.", new Object[]{url});
                throw new LegoCheckedException(104403L, new String[]{request.getHostName()}, (Throwable)ie);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)("http request error! error code:" + e.getErrorCode()), (Throwable)e);
                throw e;
            }
            catch (Exception ex) {
                logger.error((Object)("Exception, method=" + method + ", url=" + url + ExceptionUtil.getErrorMessage((Throwable)ex)));
                throw new LegoCheckedException(-1L, (Throwable)ex);
            }
        }
        logger.debug((Object)"Exit processRequest.");
        return restResponse;
    }

    private static ClassicHttpRequest buildHttpRequest(String method, String url, RestRequestData request) {
        HttpGet httpRequest;
        if ("GET".equals(method)) {
            httpRequest = new HttpGet(url);
        } else if ("POST".equals(method)) {
            HttpPost httpPost = new HttpPost(url);
            StringEntity entity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            httpPost.setEntity((HttpEntity)entity);
            httpRequest = httpPost;
        } else if ("PUT".equals(method)) {
            HttpPut httpPut = new HttpPut(url);
            StringEntity stringEntity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
            httpPut.setEntity((HttpEntity)stringEntity);
            httpRequest = httpPut;
        } else if ("DELETE".equals(method)) {
            httpRequest = new HttpDelete(url);
            if (!VerifyUtil.isEmpty((String)request.getBody())) {
                StringEntity stringEntity = new StringEntity(request.getBody(), ContentType.APPLICATION_JSON);
                httpRequest.setEntity((HttpEntity)stringEntity);
            }
        } else {
            logger.error((Object)("Illegal method: " + method));
            throw new LegoCheckedException(1073947393L);
        }
        return httpRequest;
    }

    private static void receiveResponse(RestResponseData response, CloseableHttpResponse httpResponse) throws IOException {
        BufferedReader reader = null;
        try {
            int statusCode = httpResponse.getCode();
            if (statusCode >= 200 && statusCode < 300) {
                String line;
                HttpEntity entity = httpResponse.getEntity();
                reader = new BufferedReader(new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8));
                BufferedReaderDecorator decorator = new BufferedReaderDecorator(reader);
                StringBuilder sb = new StringBuilder();
                while (null != (line = decorator.readLine())) {
                    sb.append(line + "\n");
                }
                response.setBody(sb.toString());
                response.setSuccess(true);
                Header[] httpHeaders = httpResponse.getHeaders();
                RestClient.setResponse(response, httpHeaders);
            }
            response.setHttpStatusCode(statusCode);
            if ((long)statusCode == 404L) {
                logger.error((Object)("http status code is :" + statusCode));
                throw new LegoCheckedException(404L);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"UnsupportedEncodingException error,error:%s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            response.setSuccess(false);
            throw e;
        }
        finally {
            if (reader != null) {
                CommonUtil.closeReader(reader);
            }
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
    }

    private static void setResponse(RestResponseData response, Header[] httpHeaders) {
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        if (null != httpHeaders && httpHeaders.length > 0) {
            for (Header header : httpHeaders) {
                String name = header.getName();
                String value = header.getValue();
                ArrayList<String> values = (ArrayList<String>)headerMap.get(name);
                if (null == values) {
                    values = new ArrayList<String>();
                    headerMap.put(name, values);
                }
                values.add(value);
            }
        }
        response.setHeaders(headerMap);
    }

    private static void setHttpHeaders(RestRequestData request, ClassicHttpRequest httpRequest) {
        Map<String, String> headers = request.getHeaders();
        if (null != headers && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpRequest.addHeader(entry.getKey(), (Object)entry.getValue());
            }
        }
        String requestDate = RestClient.getHttpRequestDate();
        httpRequest.addHeader("Date", (Object)requestDate);
        httpRequest.addHeader("Host", (Object)request.getHostName());
        httpRequest.addHeader("User-Agent", (Object)LegoBaseConfig.getDeployConfig().getKeyValue("version"));
    }

    private static String getHttpRequestDate() {
        Locale aLocale = Locale.US;
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z", new DateFormatSymbols(aLocale));
        fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
        return fmt.format(new Date());
    }
}

