/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.IRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractRestConnectionManager<T extends RestConnection>
implements IRestConnectionManager<T> {
    protected final ConcurrentHashMap<String, T> cache = new ConcurrentHashMap();

    @Override
    public Optional<T> getExistConnection(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            this.getLogger().error((Object)"Param devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return Optional.ofNullable(this.cache.get(devSn));
    }

    @Override
    public T getConnection(String devSn) {
        return (T)((RestConnection)this.getConnectionOptional(devSn).orElseThrow(() -> new LegoCheckedException(1073947649L)));
    }

    @Override
    public Optional<T> getConnectionOptional(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            this.getLogger().error((Object)"Param devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return Optional.ofNullable(this.cache.computeIfAbsent(devSn, key -> {
            this.getLogger().info((Object)"No connection exists for device %s, start to build a new one.", new Object[]{SecurityUtil.desensitizeId((String)key)});
            return this.buildConnection((String)key);
        }));
    }

    private T buildConnection(String devSn) {
        INeMgrProtocolExtendService protocolExtendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        return (T)Optional.ofNullable(protocolExtendService.findBySn(devSn)).map(this::buildConnection).orElseGet(() -> {
            this.getLogger().error((Object)"No protocol info available for device %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            return null;
        });
    }

    @Override
    public T buildConnection(NeMgrProtocolExtend protocolExtend) {
        if (protocolExtend == null) {
            this.getLogger().error((Object)"Param neMgrProtocolExtend info is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String ipAddress = protocolExtend.getNetworkIpAddress();
        int port = NumberUtil.parseInteger(protocolExtend.getExtendParams().get("port"));
        String userName = protocolExtend.getNetworkUserName();
        String password = protocolExtend.getNetworkPassword();
        return this.buildConnection(ipAddress, port, userName, password);
    }

    public abstract T buildConnection(String var1, int var2, String var3, String var4);

    @Override
    public Optional<T> putConnection(RestConnection connection) {
        if (connection == null) {
            this.getLogger().error((Object)"Connection is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!connection.isValid()) {
            this.getLogger().error((Object)"Connection is not valid.");
            throw new LegoCheckedException(1073947393L);
        }
        String devSn = connection.getDeviceId();
        if (VerifyUtil.isEmpty((String)devSn)) {
            this.getLogger().error((Object)"Device ID of connection is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection oldConnection = (RestConnection)this.cache.put(devSn, this.castConnection(connection));
        if (connection != oldConnection) {
            this.logoutConnection(oldConnection);
        }
        return Optional.ofNullable(oldConnection);
    }

    protected abstract T castConnection(RestConnection var1);

    @Override
    public Optional<T> removeConnection(String devSn) {
        RestConnection oldConnection = (RestConnection)this.cache.remove(devSn);
        this.logoutConnection(oldConnection);
        return Optional.ofNullable(oldConnection);
    }

    private void logoutConnection(T connection) {
        if (connection == null) {
            return;
        }
        try {
            this.getLogger().info((Object)"Begin to logout rest connection of device %s.", new Object[]{SecurityUtil.desensitizeId((String)((RestConnection)connection).getDeviceId())});
            ((RestConnection)connection).logout();
        }
        catch (Exception ex) {
            this.getLogger().error((Object)"Fail to logout rest connection, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
    }

    protected abstract Log getLogger();
}

