/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.cbb.proxy.protocol.rest.RestClient;
import com.huawei.ism.cbb.proxy.protocol.rest.RestRequestData;
import com.huawei.ism.cbb.proxy.protocol.rest.RestResponseData;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;

public class HvsRestConnection
extends RestConnection {
    private static final String KEY_DATA = "data";
    private static final String KEY_LIST = "list";
    private static Log logger = LogFactory.getInstance(HvsRestConnection.class);
    private static final long UNAUTH_ERROR_CODE = -401L;
    private CloseableHttpClient httpClient = null;
    private String authCookie;
    private final String contextPath = ResourceHelper.getValue("hvs.contextpath");
    private final int userScope = 0;

    public HvsRestConnection(String ipAddress, int port, String username, String password) {
        super(ipAddress, port, username, password);
        if (this.getPort() == 0) {
            this.setPort(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.port")));
        }
        this.setProtocol(NumberUtil.parseInteger((Object)ResourceHelper.getValue("hvs.protocol")));
    }

    @Override
    public void authenticate() {
        JSONObject jsonObject;
        JSONObject error;
        RestResponseData response = this.getRestResponseData();
        if (response.getHeaders() == null) {
            logger.warn((Object)"The response body is empty!");
            throw new LegoCheckedException(0x300001L);
        }
        List<String> cookies = response.getHeaders().get("Set-Cookie");
        if (!VerifyUtil.isEmpty(cookies)) {
            this.authCookie = cookies.get(0);
        }
        Long errorCode = (error = JSONObject.fromObject((Object)(jsonObject = JSONObject.fromObject((Object)response.getBody())).get("error"))).containsKey((Object)"code") ? Long.valueOf(error.getLong("code")) : null;
        String ipAddress = this.getIpAddress();
        String deviceId = this.getDeviceId();
        if (errorCode != null && errorCode != 0L) {
            logger.error((Object)"The errorCode=%s, ip=%s, devSn=%s.", new Object[]{errorCode, ipAddress, SecurityUtil.desensitizeId((String)deviceId)});
            throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
        }
        JSONObject data = JSONObject.fromObject((Object)jsonObject.get(KEY_DATA));
        deviceId = data.getString("deviceid");
        this.setDeviceId(deviceId);
        logger.info((Object)"Establish rest connection, ip=%s, devSn=%s.", new Object[]{ipAddress, SecurityUtil.desensitizeId((String)deviceId)});
        try {
            this.setToken(data.getString("iBaseToken"));
        }
        catch (Exception e) {
            logger.error((Object)"Getting iBaseToken failed,error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        if (!this.isValid()) {
            logger.error((Object)"The connection is not valid. ip=%s, devSn=%s.", new Object[]{ipAddress, SecurityUtil.desensitizeId((String)deviceId)});
            this.logout();
            throw new LegoCheckedException(1073947393L);
        }
    }

    private RestResponseData getRestResponseData() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("username", this.getUserName());
        paramMap.put("password", this.getPassword());
        paramMap.put("scope", String.valueOf(0));
        return this.postAndGetResponseData("/rest/${deviceID}/sessions", paramMap);
    }

    @Override
    public Map<String, String> post(String url, Map<String, String> paramMap) {
        RestResponseData response = this.postAndGetResponseData(url, paramMap);
        return this.parseResponseData(response);
    }

    @Override
    public String postForObject(String url, Object object) {
        RestResponseData response = this.postAndGetResponseData(url, object);
        Map<String, String> resultData = this.parseResponseData(response);
        return JSONObject.fromObject(resultData).toString();
    }

    @Override
    public Map<String, String> put(String url, Map<String, String> paramMap) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("PUT");
        this.buildRestRequestData(url, paramMap, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    private RestResponseData postAndGetResponseData(String url, Object requestData) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("POST");
        this.buildRestRequestData(url, requestData, request);
        return RestClient.processRequest(this.getHttpClient(), request);
    }

    @Override
    public Map<String, String> get(String url, Map<String, String> paramMap) {
        List<Map<String, String>> resultDatas = this.getBatch(url, paramMap, false);
        if (!VerifyUtil.isEmpty(resultDatas)) {
            return resultDatas.get(0);
        }
        return Collections.emptyMap();
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap, boolean page) {
        logger.debug((Object)String.format(Locale.ROOT, "Begin to send page query request for url(%s).", url));
        ArrayList<Map<String, String>> resultDatas = new ArrayList<Map<String, String>>();
        if (!page || !this.isPagingQuery(url)) {
            RestRequestData request = new RestRequestData();
            request.setRequestMethod("GET");
            this.buildRestRequestData(url, paramMap, request);
            RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            if (jsonObject == null || jsonObject.isEmpty()) {
                logger.warn((Object)"response body is empty!");
                return resultDatas;
            }
            JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
            Long errorCode = null;
            if (error != null && !error.isEmpty()) {
                errorCode = error.getLong("code");
            }
            if (errorCode != null && errorCode != 0L) {
                if (errorCode == -401L) {
                    logger.error((Object)"[%s] auth failed. re-authenticating..", new Object[]{this.getIpAddress()});
                    this.authenticate();
                    logger.info((Object)"[%s] re-auth success.", new Object[]{this.getIpAddress()});
                }
                logger.error((Object)"Get error, code: %s, description: %s", new Object[]{errorCode, error.getString("description")});
                throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
            }
            if (jsonObject.containsKey((Object)KEY_DATA)) {
                this.retrieveResultData(resultDatas, jsonObject);
            }
            logger.debug((Object)String.format(Locale.ROOT, "send page query request for url(%s)", url));
        } else {
            this.queryByPage(url, paramMap, resultDatas);
        }
        return resultDatas;
    }

    @Override
    public List<Map<String, String>> getBatch(String url, Map<String, String> paramMap) {
        return this.getBatch(url, paramMap, true);
    }

    private void queryByPage(String url, Map<String, String> paramMap, List<Map<String, String>> resultDatas) {
        List<Map<String, String>> tempResultDatas;
        int pageSize = 100;
        int ss = 0;
        do {
            int ee = ss + pageSize;
            String aa = url.replaceAll("([?&]range=\\[)\\d+-\\d+(\\](&|$))", String.format(Locale.ROOT, "$1%s-%s$2", ss, ee));
            ss += pageSize;
            try {
                tempResultDatas = this.getBatch(aa, paramMap, false);
            }
            catch (LegoCheckedException ex) {
                StringBuilder sb = new StringBuilder();
                sb.append("Execute paging query failed, error code is ");
                sb.append(ex.getErrorCode());
                sb.append(", error message is ");
                sb.append(ex.getMessage());
                sb.append(" May be the device does not support the rest interface.");
                logger.warn((Object)sb.toString());
                logger.warn((Object)"The rest url is %s.", new Object[]{aa});
                break;
            }
            logger.info((Object)"The url=%s.", new Object[]{aa});
            if (VerifyUtil.isEmpty(tempResultDatas)) break;
            logger.info((Object)"The record size is %s.", new Object[]{String.valueOf(tempResultDatas.size())});
            resultDatas.addAll(tempResultDatas);
        } while (tempResultDatas.size() == pageSize);
    }

    @Override
    public Map<String, String> putForObject(String url, Object object) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("PUT");
        this.buildRestRequestData(url, JSONObject.fromObject((Object)object), request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    @Override
    public void delete(String url, Map<String, String> paramMap) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("DELETE");
        this.buildRestRequestData(url, paramMap, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        this.parseResponseData(response);
    }

    @Override
    public Map<String, String> deleteForObject(String url, Object object) {
        RestRequestData request = new RestRequestData();
        request.setRequestMethod("DELETE");
        this.buildRestRequestData(url, object, request);
        RestResponseData response = RestClient.processRequest(this.getHttpClient(), request);
        return this.parseResponseData(response);
    }

    private CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = RestClient.buildHttpClient(this.getIpAddress());
        }
        return this.httpClient;
    }

    @Override
    public void logout() {
        String deviceId = this.getDeviceId();
        String token = this.getToken();
        logger.info((Object)"Rest connection logout, devSn=%s.", new Object[]{deviceId});
        if (token != null && !token.isEmpty()) {
            this.delete("/rest/${deviceID}/sessions", null);
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException ex) {
                logger.error((Object)"close httpClient error.", (Throwable)ex);
            }
            this.httpClient = null;
        }
        logger.info((Object)"Logout, devSn=%s, ip=%s.", new Object[]{this.getDeviceId(), this.getIpAddress()});
    }

    public void buildRestRequestData(String url, Object requestData, RestRequestData request) {
        if (url == null) {
            logger.error((Object)"The context is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String ip = this.getIpAddress();
        if (Ipv6AddressUtil.isIPv6Address((String)ip)) {
            ip = Ipv6AddressUtil.convertIpv6((String)ip);
        }
        request.setProtocol(this.getProtocol());
        request.setHostName(ip);
        request.setPort(this.getPort());
        StringBuilder sb = new StringBuilder();
        sb.append(this.getProtocol() == 0 ? "http://" : "https://");
        sb.append(ip);
        sb.append(":").append(this.getPort());
        sb.append(this.contextPath);
        sb.append(url.replace("${deviceID}", this.getDeviceId()));
        request.setUri(sb.toString());
        if (!VerifyUtil.isEmpty((Object)requestData)) {
            String requestContent = requestData instanceof List ? JSONArray.fromObject((Object)requestData).toString() : JSONObject.fromObject((Object)requestData).toString();
            request.setBody(requestContent);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Cookie", this.authCookie);
        String token = this.getToken();
        if (!VerifyUtil.isEmpty((String)token)) {
            headerMap.put("iBaseToken", token);
        }
        request.setHeaders(headerMap);
    }

    private Map<String, String> convertJsonObject2Map(JSONObject data) {
        logger.debug((Object)"Enter convertJSONObject2Map.");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (data == null) {
            return resultMap;
        }
        Iterator iterator = data.keys();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = data.get(key.toString());
            if (value == null) continue;
            resultMap.put(key.toString(), value.toString());
        }
        return resultMap;
    }

    private Map<String, String> parseResponseData(RestResponseData response) {
        logger.debug((Object)"Enter parseResponseData.");
        Map<String, String> resultData = Collections.emptyMap();
        if (response != null) {
            JSONObject jsonObject = JSONObject.fromObject((Object)response.getBody());
            JSONObject error = JSONObject.fromObject((Object)jsonObject.get("error"));
            Long errorCode = error.getLong("code");
            if (errorCode != null && errorCode != 0L) {
                String errorParam;
                if (errorCode == -401L) {
                    logger.error((Object)"[%s] auth failed. re-authenticating...", new Object[]{this.getIpAddress()});
                    this.authenticate();
                    logger.info((Object)"[%s] re-auth success.", new Object[]{this.getIpAddress()});
                }
                String string = errorParam = error.containsKey((Object)"errorParam") ? error.getString("errorParam") : null;
                if (!VerifyUtil.isEmpty((String)errorParam)) {
                    logger.error((Object)error.getString("description"));
                    String[] errParams = errorParam.split(",");
                    throw new LegoCheckedException(errorCode.longValue(), StringUtil.getErrorCodeParams((String[])errParams));
                }
                throw new LegoCheckedException(errorCode.longValue(), error.getString("description"));
            }
            if (jsonObject.containsKey((Object)KEY_DATA)) {
                Object dataObject = jsonObject.get(KEY_DATA);
                if (dataObject instanceof List) {
                    JSONObject listObject = new JSONObject();
                    listObject.put((Object)KEY_LIST, dataObject);
                    dataObject = listObject;
                }
                JSONObject data = JSONObject.fromObject((Object)dataObject);
                resultData = this.convertJsonObject2Map(data);
            }
        }
        return resultData;
    }

    private void retrieveResultData(List<Map<String, String>> resultDatas, JSONObject jsonObject) {
        logger.debug((Object)"Enter retrieveResultData.");
        Object data = jsonObject.get(KEY_DATA);
        if (data instanceof JSONObject) {
            Map<String, String> resultMap = this.convertJsonObject2Map((JSONObject)data);
            resultDatas.add(resultMap);
        } else if (data instanceof JSONArray) {
            JSONArray dataArray = (JSONArray)data;
            int len = dataArray.size();
            for (int index = 0; index < len; ++index) {
                Map<String, String> resultMap = this.convertJsonObject2Map(dataArray.getJSONObject(index));
                resultDatas.add(resultMap);
            }
        }
    }

    @Override
    public boolean isConnected() {
        boolean isConnected = false;
        String deviceId = this.getDeviceId();
        String ipAddress = this.getIpAddress();
        try {
            Map<String, String> resultMap = this.get("/rest/${deviceID}/storagepool/count", null);
            if (!VerifyUtil.isEmpty(resultMap)) {
                isConnected = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Testing connection failed, devSn=%s, ip=%s, error isd %s.", new Object[]{deviceId, ipAddress, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return isConnected;
    }

    @Override
    public boolean isValid() {
        return this.isConnected();
    }

    @Override
    public List<Map<String, String>> pagingQuery(String url, int start, int end) {
        if (url == null) {
            logger.error((Object)"Request url is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return this.getBatch(url, null, false);
    }

    private boolean isPagingQuery(String url) {
        if (url == null) {
            return false;
        }
        try {
            Pattern urlRegex = Pattern.compile("[^?]*\\?([^=]+=(&amp;|[^&]*))*&?range=\\[(\\d+)-(\\d+)\\]([^=]+=(&amp;|[^&]*))*");
            Matcher matcher = urlRegex.matcher(url);
            return matcher.find();
        }
        catch (NumberFormatException exception) {
            logger.error((Object)"Match paging query failed, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            return false;
        }
        catch (IllegalStateException exception) {
            logger.error((Object)"Match paging query failed,, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)exception)});
            return false;
        }
    }
}

