/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.AbstractRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;

public final class HvsRestConnectionManager
extends AbstractRestConnectionManager<HvsRestConnection> {
    private static final Log logger = LogFactory.getInstance(HvsRestConnectionManager.class);
    public static final String PROTOCOL_TYPE = "REST";
    private static final HvsRestConnectionManager INSTANCE = new HvsRestConnectionManager();

    private HvsRestConnectionManager() {
    }

    public static HvsRestConnectionManager getInstance() {
        return INSTANCE;
    }

    @Override
    public String getProtocolType() {
        return PROTOCOL_TYPE;
    }

    @Override
    public HvsRestConnection castConnection(RestConnection connection) {
        if (connection instanceof HvsRestConnection) {
            return (HvsRestConnection)connection;
        }
        logger.error((Object)"Connection for device %s is not HvsRestConnection type.", new Object[]{SecurityUtil.desensitizeId((String)connection.getDeviceId())});
        throw new LegoCheckedException(1073947393L);
    }

    @Override
    public HvsRestConnection buildConnection(String ipAddress, int port, String username, String password) {
        HvsRestConnection connection = new HvsRestConnection(ipAddress, port, username, password);
        connection.authenticate();
        return connection;
    }

    @Override
    protected Log getLogger() {
        return logger;
    }
}

