/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.rest.connection;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.IRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class RestConnectionManagerProxy
implements IRestConnectionManager<RestConnection> {
    private static final Log logger = LogFactory.getInstance(RestConnectionManagerProxy.class);
    private static final RestConnectionManagerProxy INSTANCE = new RestConnectionManagerProxy();
    private final Map<String, IRestConnectionManager<? extends RestConnection>> registry = new HashMap<String, IRestConnectionManager<? extends RestConnection>>();

    private RestConnectionManagerProxy() {
    }

    public static RestConnectionManagerProxy getInstance() {
        return INSTANCE;
    }

    @Override
    public String getProtocolType() {
        return null;
    }

    @Override
    public Optional<RestConnection> getExistConnection(String devSn) {
        return Optional.ofNullable(this.registry.values().stream().map(manager -> manager.getExistConnection(devSn)).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null));
    }

    @Override
    public RestConnection getConnection(String devSn) {
        return this.getManagerByDevSn(devSn).getConnection(devSn);
    }

    @Override
    public Optional<RestConnection> getConnectionOptional(String devSn) {
        return Optional.ofNullable(this.getManagerByDevSn(devSn).getConnectionOptional(devSn).orElse(null));
    }

    @Override
    public RestConnection buildConnection(NeMgrProtocolExtend protocolExtend) {
        return this.getManagerByProtocolExtend(protocolExtend).buildConnection(protocolExtend);
    }

    @Override
    public Optional<RestConnection> putConnection(RestConnection connection) {
        if (connection == null) {
            logger.error((Object)"Connection is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String devSn = connection.getDeviceId();
        return Optional.ofNullable(this.getManagerByDevSn(devSn).putConnection(connection).orElse(null));
    }

    @Override
    public Optional<RestConnection> removeConnection(String devSn) {
        return Optional.ofNullable(this.registry.values().stream().map(manager -> manager.removeConnection(devSn)).filter(Optional::isPresent).map(Optional::get).findAny().orElse(null));
    }

    public IRestConnectionManager<? extends RestConnection> getManagerByDevSn(String devSn) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"Param devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        Optional<IRestConnectionManager> optionalManager = this.registry.values().stream().filter(manager -> manager.getExistConnection(devSn).isPresent()).findAny();
        if (optionalManager.isPresent()) {
            return optionalManager.get();
        }
        INeMgrProtocolExtendService protocolExtendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
        return Optional.ofNullable(protocolExtendService.findBySn(devSn)).map(this::getManagerByProtocolExtend).orElseThrow(() -> {
            logger.error((Object)"No protocol info available for device %s.", new Object[]{SecurityUtil.desensitizeId((String)devSn)});
            return new LegoCheckedException(1073947393L);
        });
    }

    public IRestConnectionManager<? extends RestConnection> getManagerByProtocolExtend(NeMgrProtocolExtend protocolExtend) {
        if (protocolExtend == null) {
            logger.error((Object)"Param neMgrProtocolExtend info is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return Optional.of(protocolExtend).map(NeMgrProtocolExtend::getExtendParams).map(params -> (String)params.get("protocol")).map(this::getManagerByProtocolType).orElseThrow(() -> {
            logger.error((Object)"No protocol type available for ip %s.", new Object[]{protocolExtend.getNetworkIpAddress()});
            return new LegoCheckedException(1073947393L);
        });
    }

    public IRestConnectionManager<? extends RestConnection> getManagerByProtocolType(String protocol) {
        if (VerifyUtil.isEmpty((String)protocol)) {
            logger.error((Object)"Param protocol is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        return Optional.ofNullable(this.registry.get(protocol)).orElseThrow(() -> {
            logger.error((Object)"No manager available for protocol type %s.", new Object[]{protocol});
            return new LegoCheckedException(1073947393L);
        });
    }

    public void onBind(IRestConnectionManager<? extends RestConnection> manager, Map<String, Object> properties) {
        Optional.ofNullable(manager).map(IRestConnectionManager::getProtocolType).ifPresent(protocol -> this.registry.put((String)protocol, manager));
    }

    public void onUnbind(IRestConnectionManager<? extends RestConnection> manager, Map<String, Object> properties) {
        Optional.ofNullable(manager).map(IRestConnectionManager::getProtocolType).ifPresent(this.registry::remove);
    }
}

