/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.smis.connection;

import com.huawei.ism.cbb.proxy.protocol.base.ConnectionEvent;
import com.huawei.ism.cbb.proxy.protocol.base.IConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMClient;

public class CIMClientInvocationHandler
implements InvocationHandler {
    private static final long DEFAULT_TIMEOUT = 30L;
    private static final long PARAMS_LENGTH = 2L;
    private static final int PARAMS_INDEX = 1;
    private static final String OPERATION_FAIL_STR = "Operation fails";
    private static ExecutorService newCachedExcutor = Executors.newCachedThreadPool();
    private final CIMClient cimClient;
    private final IConnection conn;
    private final long timeout;

    public CIMClientInvocationHandler(CIMClient cimClient, long timeout) {
        this(null, cimClient, timeout);
    }

    public CIMClientInvocationHandler(IConnection conn, CIMClient cimClient, long timeout) {
        this.conn = conn;
        this.cimClient = cimClient;
        this.timeout = timeout;
    }

    public CIMClientInvocationHandler(CIMClient cimClient) {
        this(cimClient, 30L);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Throwable throwable;
        CimMethodInvoker invoker = new CimMethodInvoker(this.cimClient, method, args);
        FutureTask<Object> futureTask = new FutureTask<Object>(invoker);
        Throwable exception = null;
        try {
            newCachedExcutor.execute(futureTask);
            return futureTask.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            exception = new CIMException(OPERATION_FAIL_STR, (Object)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                exception = (InvocationTargetException)cause;
            }
        }
        catch (TimeoutException e) {
            this.cimClient.closeTimeOutOperation();
            exception = new CIMException("Connection time out");
        }
        if (null == exception) {
            return null;
        }
        if (!futureTask.isCancelled()) {
            futureTask.cancel(true);
        }
        if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof CIMException) {
            CIMException cimException = (CIMException)throwable;
            Object[] params = cimException.getParams();
            if (null != params && 2L == (long)params.length) {
                Object param = params[1];
                if (param instanceof ConnectException) {
                    exception = new CIMException("Connection time out");
                    exception.setStackTrace(cimException.getStackTrace());
                }
            } else {
                exception = cimException;
                this.handlerCIMException(cimException);
            }
        }
        throw exception;
    }

    private void handlerCIMException(CIMException e) {
        if (null == this.conn) {
            return;
        }
        if ("CIM_ERR_ACCESS_DENIED".equals(e.getLocalizedMessage())) {
            ConnectionEvent.ConnectionState state = ConnectionEvent.ConnectionState.InvalidUserOrPassword;
            ConnectionEvent event = new ConnectionEvent(this.conn.getConnectionId(), state);
            this.conn.setValid(false);
            this.conn.notifyListener(event);
        }
    }

    private static final class CimMethodInvoker
    implements Callable<Object> {
        private final Method method;
        private final Object[] args;
        private final CIMClient object;

        private CimMethodInvoker(CIMClient object, Method method, Object[] args) {
            this.object = object;
            this.method = method;
            this.args = args;
        }

        @Override
        public Object call() throws IllegalAccessException, InvocationTargetException {
            if (null == this.method) {
                return null;
            }
            return this.method.invoke((Object)this.object, this.args);
        }
    }
}

