/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.smis.connection;

import com.huawei.ism.cbb.proxy.protocol.base.BaseConnection;
import com.huawei.ism.cbb.proxy.protocol.smis.connection.CIMClientInvocationHandler;
import com.huawei.ism.cbb.proxy.protocol.smis.util.SmisUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class SmisConnection
extends BaseConnection {
    public static final String CIM_ERR_CONNECTION_TIME_OUT = "Connection time out";
    private static final Log LOGGER = LogFactory.getInstance(SmisConnection.class);
    private static final int DEFAULT_HTTPS_PORT = 5989;
    private static final int TIMEOUT = 300;
    private CIMClient cimClient;
    private CIMOMHandle cimomHandle;
    private String nameSpace;
    private Map<String, CIMObjectPath> arraySystemCop;

    public SmisConnection(Properties connProperties) throws CIMException {
        super(connProperties);
    }

    public SmisConnection(String ipAddress, String userName, String password, String protocol, int port, String ns) throws CIMException {
        super.setHost(ipAddress);
        super.setUserName(userName);
        super.setPassword(password);
        super.setProtocol(protocol);
        super.setPort(port);
        this.nameSpace = ns;
        this.connect();
    }

    public SmisConnection(String ipAddress, String userName, String password, String protocol, String ns) throws CIMException {
        this(ipAddress, userName, password, protocol, 5989, ns);
    }

    @Override
    public void close() {
        this.setValid(false);
        if (null != this.cimClient) {
            try {
                this.cimClient.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)("Close smis connection error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658373L);
            }
        }
    }

    public CIMObjectPath getArraySystemObjectPath(String deviceId) {
        if (null == this.arraySystemCop) {
            return null;
        }
        CIMObjectPath path = this.arraySystemCop.get(deviceId);
        if (null != path) {
            return path;
        }
        for (Map.Entry<String, CIMObjectPath> entry : this.arraySystemCop.entrySet()) {
            String key = entry.getKey();
            if (key.indexOf(deviceId) <= -1) continue;
            return entry.getValue();
        }
        return null;
    }

    public Map<String, CIMObjectPath> getArraySystemCop() {
        return this.arraySystemCop;
    }

    public void setArraySystemCop(Map<String, CIMObjectPath> arraySystemCop) {
        this.arraySystemCop = arraySystemCop;
    }

    public Map<String, Object> getComputerSystemInfo(String deviceSn) throws CIMException {
        CIMObjectPath path = this.getArraySystemObjectPath(deviceSn);
        return SmisUtil.fetchArrayBasicInfo(this.getCIMClientProxy(), path);
    }

    public CIMOMHandle getCIMClientProxy() {
        if (null == this.cimomHandle) {
            CIMClientInvocationHandler handler = new CIMClientInvocationHandler(this, this.cimClient, 300L);
            this.cimomHandle = (CIMOMHandle)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CIMOMHandle.class}, (InvocationHandler)handler);
        }
        return this.cimomHandle;
    }

    public CIMClient getCimClient() {
        return this.cimClient;
    }

    public void setCimClient(CIMClient cimClient) {
        this.cimClient = cimClient;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    @Override
    protected void init(Properties connProperties) throws CIMException {
        if (null == connProperties) {
            throw new LegoCheckedException(1073947393L);
        }
        this.nameSpace = connProperties.getProperty("namespace");
        super.setHost(connProperties.getProperty("ipAddress"));
        super.setUserName(connProperties.getProperty("userName"));
        super.setPassword(connProperties.getProperty("password"));
        super.setProtocol(connProperties.getProperty("protocol"));
        String portStr = connProperties.getProperty("port");
        try {
            super.setPort(Integer.parseInt(portStr));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e, 90160777658373L);
            super.setPort(5989);
        }
        this.connect();
    }

    private CIMOMHandle getCIMClientProxy(CIMClient client) {
        CIMClientInvocationHandler handler = new CIMClientInvocationHandler(client, 300L);
        return (CIMOMHandle)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{CIMOMHandle.class}, (InvocationHandler)handler);
    }

    private CIMClient getTempCIMClient(String namespace) throws CIMException {
        CIMNameSpace ns = SmisUtil.createNameSpace(super.getProtocol(), super.getHost(), super.getPort(), namespace);
        return new CIMClient(ns, (Principal)new UserPrincipal(super.getUserName()), (Object)new PasswordCredential(super.getPassword()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws CIMException {
        CIMClient client = this.getTempCIMClient(this.nameSpace);
        try {
            CIMOMHandle cimOMHandle = this.getCIMClientProxy(client);
            CIMObjectPath objectPath = SmisUtil.getArrayObjectPath(cimOMHandle);
            this.arraySystemCop = SmisUtil.getComputerSystemObjectPath(cimOMHandle, objectPath);
        }
        finally {
            if (null != client) {
                try {
                    client.close();
                }
                catch (CIMException ex) {
                    LOGGER.error((Object)ex, 90160777658373L);
                }
            }
        }
        this.cimClient = SmisUtil.createCIMClient(super.getHost(), super.getUserName(), super.getPassword(), super.getProtocol(), super.getPort(), this.nameSpace);
        this.setValid(true);
        this.setConnected(true);
        this.setConnectionId(this.getHost());
    }
}

