/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.smis.connection;

import com.huawei.ism.cbb.proxy.protocol.base.IConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.smis.connection.SmisConnection;
import com.huawei.ism.cbb.proxy.protocol.smis.util.SmisUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.wbem.cim.CIMException;

@ServiceBoundInfo(methodName="onBind", targetBeanName="connectionManagerFactory", properties="ConnectionType:SMI-S")
public final class SmisConnectionManager
implements IConnectionManager {
    private static SmisConnectionManager manager = null;
    private static Log logger = LogFactory.getInstance(SmisUtil.class);
    private final Map<String, SmisConnection> connMap = new ConcurrentHashMap<String, SmisConnection>();

    private SmisConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmisConnectionManager getInstance() {
        Class<SmisConnectionManager> clazz = SmisConnectionManager.class;
        synchronized (SmisConnectionManager.class) {
            if (null == manager) {
                manager = new SmisConnectionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    @Override
    public SmisConnection getConnection(Properties connProperties) throws CIMException {
        return this.getConnection(connProperties, null);
    }

    public SmisConnection getConnection(Properties connProperties, String key) throws CIMException {
        SmisConnection conn;
        if (null == connProperties) {
            throw new IllegalArgumentException();
        }
        String connectKey = connProperties.getProperty("ipAddress");
        if (null != key) {
            connectKey = key;
        }
        if (null != (conn = this.getConnection(connectKey)) && conn.isValid()) {
            logger.info((Object)(" getConnection  connectkey=" + connectKey + " from buffer"), 90160777658372L);
            return conn;
        }
        conn = new SmisConnection(connProperties);
        this.connMap.put(connectKey, conn);
        return conn;
    }

    @Override
    public SmisConnection getConnection(String connectionId) {
        logger.info((Object)("into getConnection connectionId=" + connectionId), 90160777658372L);
        return this.connMap.get(connectionId);
    }

    @Override
    public void removeAllConnection() {
        this.connMap.clear();
    }

    @Override
    public boolean removeConnection(String connectionId) throws CIMException {
        SmisConnection conn = this.getConnection(connectionId);
        if (null != conn) {
            logger.info((Object)("into removeConnection connectionId=" + connectionId), 90160777658372L);
            conn.close();
            this.connMap.remove(connectionId);
        }
        return null != conn;
    }
}

