/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.smis.util;

import com.huawei.ism.cbb.proxy.protocol.smis.connection.SmisConnection;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import javax.wbem.client.CIMClient;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class SmisUtil {
    private static final Log LOGGER = LogFactory.getInstance(SmisUtil.class);
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final int UNRESTRICTED = 2;
    private static final int CONSTVAULE2 = 2;
    private static final int CONSTVAULE3 = 3;
    private static final int SNIA_ORGANIZATION = 11;

    public static CIMClient createCIMClient(String ipAddress, String userName, String password, String protocol, int port, String ns) throws CIMException {
        CIMNameSpace cimNameSpace = SmisUtil.createNameSpace(protocol, ipAddress, port, ns);
        return new CIMClient(cimNameSpace, (Principal)new UserPrincipal(userName), (Object)new PasswordCredential(password));
    }

    public static CIMNameSpace createNameSpace(String protocol, String ipAddress, int port, String ns) {
        if (null == protocol) {
            throw new NullPointerException("protocol parameter is null");
        }
        if (VerifyUtil.isNone((String)ns)) {
            throw new NullPointerException("Namespace parameter is null");
        }
        if (HTTPS.equalsIgnoreCase(protocol) || HTTP.equalsIgnoreCase(protocol)) {
            StringBuffer sb = new StringBuffer();
            sb.append(protocol);
            sb.append("://");
            sb.append(ipAddress);
            sb.append(':');
            sb.append(port);
            sb.append('/');
            sb.append(ns);
            String uri = sb.toString();
            try {
                return new CIMNameSpace(uri);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"", (long)104402L, null, (Log)LOGGER);
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown protocol");
    }

    public static CIMObjectPath getArrayObjectPath(CIMOMHandle client) throws CIMException {
        if (null == client) {
            return null;
        }
        CIMObjectPath result = null;
        CIMObjectPath objPath = new CIMObjectPath("CIM_RegisteredProfile");
        Enumeration enumRegisteredProfile = client.enumerateInstances(objPath, true, true, false, false, null);
        if (null == enumRegisteredProfile) {
            return null;
        }
        while (enumRegisteredProfile.hasMoreElements()) {
            CIMInstance inst = (CIMInstance)enumRegisteredProfile.nextElement();
            String registeredName = SmisUtil.getStringValue(inst, "RegisteredName");
            int organization = SmisUtil.getIntValue(inst, "RegisteredOrganization");
            if (!"Array".equalsIgnoreCase(registeredName) || 11 != organization) continue;
            result = inst.getObjectPath();
            break;
        }
        return result;
    }

    public static Map<String, CIMObjectPath> getComputerSystemObjectPath(CIMOMHandle client, CIMObjectPath arrayObjectPath) throws CIMException {
        if (null == client) {
            return null;
        }
        HashMap<String, CIMObjectPath> arraySystemCop = new HashMap<String, CIMObjectPath>();
        Enumeration enumPaths = client.associatorNames(arrayObjectPath, "CIM_ElementConformsToProfile", "CIM_ComputerSystem", null, null);
        if (null == enumPaths) {
            return null;
        }
        while (enumPaths.hasMoreElements()) {
            CIMObjectPath objPath = (CIMObjectPath)enumPaths.nextElement();
            Object key = SmisUtil.getPropertyValue(objPath.getKey("Name"));
            if (null == key) continue;
            arraySystemCop.put(key.toString(), objPath);
        }
        return arraySystemCop;
    }

    public static Object getPropertyValue(CIMProperty property) {
        if (null == property) {
            return null;
        }
        CIMValue value = property.getValue();
        if (null == value) {
            return null;
        }
        return value.getValue();
    }

    public static String getStringValue(Map<String, Object> instance, String propertyName) {
        CIMValue value = SmisUtil.getPropertyCIMValue(instance, propertyName);
        if (null == value) {
            return null;
        }
        Object obj = value.getValue();
        if (null == obj) {
            return null;
        }
        return obj.toString();
    }

    public static CIMValue getPropertyCIMValue(Map<String, Object> instance, String propertyName) {
        if (null == instance) {
            return null;
        }
        Object property = instance.get(propertyName);
        if (property == null) {
            return null;
        }
        if (!(property instanceof CIMValue)) {
            return null;
        }
        return (CIMValue)property;
    }

    public static long getLongValue(Map<String, Object> instance, String propertyName) {
        CIMValue value = SmisUtil.getPropertyCIMValue(instance, propertyName);
        return SmisUtil.getLongValue(value);
    }

    public static boolean getBooleanValue(Map<String, Object> instance, String propertyName) {
        CIMValue value = SmisUtil.getPropertyCIMValue(instance, propertyName);
        if (null == value) {
            return false;
        }
        Object valueObj = value.getValue();
        if (valueObj instanceof Boolean) {
            return (Boolean)valueObj;
        }
        return false;
    }

    public static long getLongValue(CIMValue value) {
        if (null == value) {
            return -1L;
        }
        Object obj = value.getValue();
        if (obj instanceof UnsignedInt64 || obj instanceof UnsignedInt32 || obj instanceof UnsignedInt16 || obj instanceof UnsignedInt8) {
            try {
                return Long.parseLong(value.toString());
            }
            catch (Exception e) {
                return -1L;
            }
        }
        return -1L;
    }

    public static String getStringValue(CIMInstance instance, String propertyName) {
        Object value = SmisUtil.getPropertyValue(instance, propertyName);
        if (null == value) {
            return null;
        }
        return value.toString();
    }

    public static long getLongValue(CIMInstance instance, String propertyName) {
        CIMValue value = SmisUtil.getPropertyCIMValue(instance, propertyName);
        return SmisUtil.getLongValue(value);
    }

    public static Object getPropertyValue(CIMInstance instance, String propertyName) {
        CIMValue value = SmisUtil.getPropertyCIMValue(instance, propertyName);
        if (value == null) {
            return null;
        }
        return value.getValue();
    }

    public static CIMValue getPropertyCIMValue(CIMInstance instance, String propertyName) {
        if (null == instance) {
            return null;
        }
        CIMProperty property = instance.getProperty(propertyName);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public static int getIntValue(CIMInstance instance, String propertyName) {
        return (int)SmisUtil.getLongValue(instance, propertyName);
    }

    public static boolean getBooleanValue(CIMInstance instance, String propertyName) {
        Object value = SmisUtil.getPropertyValue(instance, propertyName);
        if (null == value) {
            return false;
        }
        if (!(value instanceof Boolean)) {
            return false;
        }
        try {
            return Boolean.valueOf(value.toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Calendar getCalendarValue(CIMInstance instance, String propertyName) {
        Object value = SmisUtil.getPropertyValue(instance, propertyName);
        if (null == value) {
            return null;
        }
        if (value instanceof CIMDateTime) {
            Calendar retCal = ((CIMDateTime)value).getCalendar();
            retCal.setTimeInMillis(retCal.getTimeInMillis() + (long)TimeZone.getDefault().getRawOffset() - (long)retCal.getTimeZone().getRawOffset());
            return retCal;
        }
        return null;
    }

    public static List<Map<String, Object>> fetchArrayDiskInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        LOGGER.info((Object)"into fetchArrayDiskInfo", 90160777658372L);
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Enumeration<CIMInstance> enumInstance = SmisUtil.associateInstances(client, storageSystemObjPath, false, false, null, "CIM_SystemDevice", "CIM_DiskDrive", null, null);
        while (enumInstance.hasMoreElements()) {
            CIMInstance diskInstance = enumInstance.nextElement();
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(diskInstance, row);
            CIMObjectPath diskObjectPath = diskInstance.getObjectPath();
            CIMInstance tmpInstance = SmisUtil.fetchDiskPhysicalPackageInfo(client, diskObjectPath);
            SmisUtil.cimInstanceToMap(tmpInstance, row);
            tmpInstance = SmisUtil.fetchDiskFirmware(client, diskObjectPath);
            SmisUtil.cimInstanceToMap(tmpInstance, row);
            tmpInstance = SmisUtil.fetchDiskExtendInfo(client, diskObjectPath);
            SmisUtil.cimInstanceToMap(tmpInstance, row);
            if (null != tmpInstance) {
                String poolId;
                CIMObjectPath extendInfoPath = tmpInstance.getObjectPath();
                if (null != (tmpInstance = SmisUtil.fetchDiskRedanceySet(client, extendInfoPath))) {
                    row.put("IsSpare", new CIMValue((Object)true));
                }
                if (null != (poolId = SmisUtil.getDiskPoolId(client, extendInfoPath))) {
                    row.put("PoolID", new CIMValue((Object)poolId));
                }
            }
            results.add(row);
        }
        LOGGER.info((Object)"out fetchArrayDiskInfo", 90160777658372L);
        return results;
    }

    private static String getDiskPoolId(CIMOMHandle client, CIMObjectPath extendInfoPath) {
        CIMObjectPath pathHelper = extendInfoPath;
        while (true) {
            Enumeration enumTmp;
            try {
                enumTmp = client.associators(pathHelper, "CIM_ConcreteComponent", "CIM_StoragePool", "PartComponent", "GroupComponent", false, false, null);
            }
            catch (CIMException e) {
                continue;
            }
            if (enumTmp.hasMoreElements()) {
                do {
                    CIMInstance instHelper;
                    if (SmisUtil.getBooleanValue(instHelper = (CIMInstance)enumTmp.nextElement(), "Primordial")) continue;
                    return SmisUtil.getStringValue(instHelper, "InstanceID");
                } while (enumTmp.hasMoreElements());
                if ((pathHelper = SmisUtil.associatorObjectPath(client, pathHelper, "CIM_BasedOn", null, "Antecedent", "Dependent")) != null) continue;
                return null;
            }
            if ((pathHelper = SmisUtil.associatorObjectPath(client, pathHelper, "CIM_BasedOn", null, "Antecedent", "Dependent")) == null) break;
        }
        return null;
    }

    public static List<Map<String, Object>> fetchArrayStoragePoolInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (null == client) {
            return results;
        }
        Enumeration<CIMInstance> enumInstance = SmisUtil.associateInstances(client, storageSystemObjPath, false, false, null, "CIM_HostedStoragePool", "CIM_StoragePool", null, null);
        while (enumInstance.hasMoreElements()) {
            int usage;
            CIMInstance instance = enumInstance.nextElement();
            if (SmisUtil.getBooleanValue(instance, "Primordial") || (usage = SmisUtil.getIntValue(instance, "Usage")) != 2 && usage != -1) continue;
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(instance, row);
            CIMValue raidLevel = SmisUtil.getStoragePoolRaidLevel(client, instance.getObjectPath());
            row.put("RaidLevel", raidLevel);
            results.add(row);
        }
        return results;
    }

    public static List<Map<String, Object>> getDiskInStoragePool(CIMOMHandle client, CIMObjectPath spPath) throws CIMException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (null == client) {
            return results;
        }
        Enumeration<CIMInstance> enumInstance = SmisUtil.associateInstances(client, spPath, false, false, null, "CIM_ConcreteComponent", "CIM_StorageExtent", null, null);
        while (enumInstance.hasMoreElements()) {
            CIMInstance instance = enumInstance.nextElement();
            CIMObjectPath path = instance.getObjectPath();
            try {
                String[] propertyList = new String[]{"DeviceID"};
                results.addAll(SmisUtil.associators(client, path, "CIM_MediaPresent", propertyList, "CIM_DiskDrive", null, null));
            }
            catch (CIMException e) {
                LOGGER.error((Object)e, 90160758784001L);
            }
        }
        return results;
    }

    public static Enumeration<CIMInstance> associateInstances(CIMOMHandle client, CIMObjectPath objectName, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, String ... args) throws CIMException {
        Enumeration<Object> results;
        if (args == null || args.length < 4) {
            return Collections.enumeration(new ArrayList());
        }
        String assocClass = args[0];
        String resultClass = args[1];
        String role = args[2];
        String resultRole = args[3];
        if (null == client) {
            return Collections.enumeration(new ArrayList());
        }
        try {
            results = client.associators(objectName, assocClass, resultClass, role, resultRole, includeQualifiers, includeClassOrigin, propertyList);
        }
        catch (CIMException e) {
            if ("Connection time out".equals(e.getLocalizedMessage())) {
                throw e;
            }
            results = Collections.enumeration(new ArrayList());
        }
        catch (Exception e) {
            results = Collections.enumeration(new ArrayList());
        }
        if (null == results) {
            results = Collections.enumeration(new ArrayList());
        }
        return results;
    }

    public static List<Map<String, Object>> fetchArrayInitiatorInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (null == client) {
            return results;
        }
        Enumeration enumInstance = client.associators(storageSystemObjPath, "CIM_ElementSettingData", null, null, null, false, false, null);
        if (null == enumInstance) {
            return results;
        }
        while (enumInstance.hasMoreElements()) {
            CIMInstance instance = (CIMInstance)enumInstance.nextElement();
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(instance, row);
        }
        return results;
    }

    public static List<Map<String, Object>> fetchArrayHostInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Enumeration<CIMInstance> enumInstance = SmisUtil.associateInstances(client, storageSystemObjPath, false, false, null, "CIM_SystemDevice", "CIM_SCSIProtocolController", null, null);
        while (enumInstance.hasMoreElements()) {
            CIMInstance instance = enumInstance.nextElement();
            SmisUtil.printClientCIMObjectPaths(client, instance.getObjectPath(), "fetchArrayHostInfo");
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(instance, row);
            results.add(row);
        }
        return results;
    }

    public static List<Map<String, Object>> fetchArrayCtrlInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Enumeration<CIMInstance> enumInstance = SmisUtil.associateInstances(client, storageSystemObjPath, false, false, null, "CIM_ComponentCS", "CIM_ComputerSystem", "GroupComponent", "PartComponent");
        while (enumInstance.hasMoreElements()) {
            CIMInstance instance = enumInstance.nextElement();
            SmisUtil.printClientCIMObjectPaths(client, instance.getObjectPath(), "fetchArrayCtrlInfo");
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(instance, row);
            CIMObjectPath path = instance.getObjectPath();
            SmisUtil.getCtrlManagerIpAddress(client, path, row);
            List<Map<String, Object>> fcPorts = SmisUtil.fetchCtrlPortInfo(client, path, "CIM_FCPort");
            if (VerifyUtil.isEmpty(fcPorts)) {
                fcPorts = SmisUtil.fetchCtrlPortInfo(client, storageSystemObjPath, "CIM_FCPort");
            }
            row.put("FCPorts", fcPorts);
            List<Map<String, Object>> iscsiPorts = SmisUtil.fetchIscsiPortsInfo(client, path);
            row.put("iSCSIPorts", iscsiPorts);
            List<Map<String, Object>> sasPorts = SmisUtil.fetchCtrlPortInfo(client, path, "CIM_SASPort");
            row.put("SASPorts", sasPorts);
            results.add(row);
        }
        return results;
    }

    private static List<Map<String, Object>> fetchIscsiPortsInfo(CIMOMHandle client, CIMObjectPath path) throws CIMException {
        ArrayList<Map<String, Object>> iscsiPorts = new ArrayList<Map<String, Object>>();
        Enumeration<CIMInstance> iscsiPortsEnumInstance = SmisUtil.associateInstances(client, path, false, false, null, "CIM_SystemDevice", "CIM_EthernetPort", "GroupComponent", "PartComponent");
        while (iscsiPortsEnumInstance.hasMoreElements()) {
            CIMInstance iscsiPortInstance = iscsiPortsEnumInstance.nextElement();
            HashMap<String, Object> iscsiPortRow = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(iscsiPortInstance, iscsiPortRow);
            CIMInstance ipProtocolInstance = SmisUtil.associatorInstance(client, iscsiPortInstance.getObjectPath(), "CIM_DeviceSAPImplementation", "CIM_IPProtocolEndpoint", new String[]{"Name", "IPv4Address", "IPv6Address"});
            SmisUtil.cimInstanceToMap(ipProtocolInstance, iscsiPortRow);
            iscsiPorts.add(iscsiPortRow);
        }
        return iscsiPorts;
    }

    public static List<?> getVectorValue(Map<String, Object> instance, String propertyName) {
        Object object;
        CIMValue value = SmisUtil.getPropertyCIMValue(instance, propertyName);
        if (value != null && (object = value.getValue()) instanceof Vector) {
            return (Vector)object;
        }
        return null;
    }

    public static List<Integer> getIntList(Map<String, Object> instance, String propertyName) {
        List<?> tmpVector = SmisUtil.getVectorValue(instance, propertyName);
        ArrayList<Integer> results = new ArrayList<Integer>();
        if (null == tmpVector) {
            return results;
        }
        for (Object obj : tmpVector) {
            if (!(obj instanceof UnsignedInt16)) continue;
            UnsignedInt16 value = (UnsignedInt16)obj;
            results.add(value.intValue());
        }
        return results;
    }

    public static List<String> getStringList(Map<String, Object> instance, String propertyName) {
        List<?> tmpVector = SmisUtil.getVectorValue(instance, propertyName);
        ArrayList<String> results = new ArrayList<String>();
        if (null == tmpVector) {
            return results;
        }
        for (Object obj : tmpVector) {
            if (!(obj instanceof String)) continue;
            results.add(obj.toString());
        }
        return results;
    }

    private static List<Map<String, Object>> fetchCtrlPortInfo(CIMOMHandle client, CIMObjectPath ctrlPath, String portTypeClass) throws CIMException {
        SmisUtil.printClientCIMObjectPaths(client, ctrlPath, "fetchCtrlPortInfo");
        return SmisUtil.associators(client, ctrlPath, "CIM_SystemDevice", portTypeClass, "GroupComponent", "PartComponent");
    }

    public static List<Map<String, Object>> associators(CIMOMHandle client, CIMObjectPath cop, String assocClass, String resultClass, String role, String resultRole) throws CIMException {
        return SmisUtil.associators(client, cop, assocClass, null, resultClass, role, resultRole);
    }

    public static List<Map<String, Object>> associators(CIMOMHandle client, CIMObjectPath cop, String assocClass, String[] propertyList, String ... args) throws CIMException {
        Enumeration enumInstance;
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        if (args == null || args.length < 3) {
            return results;
        }
        if (null == client) {
            return results;
        }
        try {
            enumInstance = client.associators(cop, assocClass, args[0], args[1], args[2], false, false, propertyList);
        }
        catch (CIMException e) {
            return results;
        }
        if (null == enumInstance) {
            return results;
        }
        while (enumInstance.hasMoreElements()) {
            CIMInstance instance = (CIMInstance)enumInstance.nextElement();
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(instance, row);
            results.add(row);
        }
        return results;
    }

    public static List<Map<String, Object>> associators(CIMOMHandle client, CIMObjectPath cop, String assocClass, String resultClass) throws CIMException {
        return SmisUtil.associators(client, cop, assocClass, resultClass, null, null);
    }

    public static List<Map<String, Object>> fetchArrayStorageVolumeInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Enumeration<CIMInstance> enumInstance = SmisUtil.associateInstances(client, storageSystemObjPath, false, false, null, "CIM_SystemDevice", "CIM_StorageVolume", null, null);
        while (enumInstance.hasMoreElements()) {
            CIMInstance instance = enumInstance.nextElement();
            HashMap<String, Object> row = new HashMap<String, Object>();
            SmisUtil.cimInstanceToMap(instance, row);
            CIMObjectPath path = instance.getObjectPath();
            SmisUtil.getStorageVolumePoolInfo(client, path, row);
            SmisUtil.getStorageVolumeMappingState(client, path, row);
            results.add(row);
        }
        return results;
    }

    public static void getCtrlManagerIpAddress(CIMOMHandle client, CIMObjectPath ctrlPath, Map<String, Object> rowData) {
        try {
            CIMInstance instance = SmisUtil.associatorInstance(client, ctrlPath, "CIM_HostedAccessPoint", "CIM_RemoteServiceAccessPoint", null);
            if (null != instance) {
                rowData.put("AccessInfo", SmisUtil.getPropertyCIMValue(instance, "AccessInfo"));
            }
        }
        catch (CIMException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e, 90160777658373L);
            rowData.put("AccessInfo", "--");
        }
    }

    private static void getStorageVolumePoolInfo(CIMOMHandle client, CIMObjectPath path, Map<String, Object> row) {
        try {
            CIMInstance instance = SmisUtil.associatorInstance(client, path, true, true, null, "CIM_AllocatedFromStoragePool", "CIM_StoragePool");
            row.put("PoolID", SmisUtil.getPropertyCIMValue(instance, "InstanceID"));
            row.put("PoolName", SmisUtil.getPropertyCIMValue(instance, "ElementName"));
        }
        catch (CIMException e) {
            row.put("PoolName", "--");
        }
    }

    private static void getStorageVolumeMappingState(CIMOMHandle client, CIMObjectPath path, Map<String, Object> row) {
        try {
            CIMInstance instance = SmisUtil.associatorInstance(client, path, true, true, null, "CIM_ProtocolControllerForUnit", "CIM_SCSIProtocolController");
            if (null != instance) {
                row.put("IsMapped", new CIMValue((Object)true));
            }
        }
        catch (CIMException e) {
            row.put("IsMapped", new CIMValue((Object)false));
        }
    }

    private static CIMObjectPath getSPStorageCapabilitiesObjectPath(CIMOMHandle client, CIMObjectPath spObjPath) {
        return SmisUtil.associatorObjectPath(client, spObjPath, "CIM_ElementCapabilities", "CIM_StorageCapabilities", null, null);
    }

    private static CIMValue getStoragePoolRaidLevel(CIMOMHandle client, CIMObjectPath spObjPath) {
        try {
            CIMObjectPath path = SmisUtil.getSPStorageCapabilitiesObjectPath(client, spObjPath);
            if (null == path) {
                return null;
            }
            CIMInstance instance = SmisUtil.associatorInstance(client, path, false, false, null, "CIM_StorageSettingsAssociatedToCapabilities", "CIM_StorageSetting");
            return SmisUtil.getPropertyCIMValue(instance, "ElementName");
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160777658373L);
            return null;
        }
    }

    public static CIMObjectPath associatorObjectPath(CIMOMHandle client, CIMObjectPath cop, String assocClass, String resultClass, String role, String resultRole) {
        Enumeration paths;
        try {
            paths = client.associatorNames(cop, assocClass, resultClass, role, resultRole);
        }
        catch (CIMException e) {
            LOGGER.error((Object)e, 90160758784001L);
            return null;
        }
        if (null == paths || !paths.hasMoreElements()) {
            return null;
        }
        return (CIMObjectPath)paths.nextElement();
    }

    private static CIMInstance fetchDiskRedanceySet(CIMOMHandle client, CIMObjectPath diskObjectPath) throws CIMException {
        return SmisUtil.associatorInstance(client, diskObjectPath, false, false, null, "CIM_IsSpare", "CIM_StorageRedundancySet");
    }

    private static void printClientCIMObjectPaths(CIMOMHandle client, CIMObjectPath diskObjectPath, String feature) throws CIMException {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.info((Object)"begin printClientCIMObjectPaths=", 90160777658372L);
        LOGGER.info((Object)("printClientCIMObjectPaths feature-->" + feature), 90160777658372L);
        Enumeration results = client.associators(diskObjectPath);
        while (results.hasMoreElements()) {
            CIMInstance item = (CIMInstance)results.nextElement();
            LOGGER.info((Object)("printClientCIMObjectPaths CIMInstance=" + item.getName()), 90160777658372L);
        }
        LOGGER.info((Object)"end printClientCIMObjectPaths -->", 90160777658372L);
    }

    private static CIMInstance fetchDiskExtendInfo(CIMOMHandle client, CIMObjectPath diskObjectPath) throws CIMException {
        String[] propertyList = new String[]{"BlockSize", "NumberOfBlocks", "ConsumableBlocks", "ExtentStatus"};
        return SmisUtil.associatorInstance(client, diskObjectPath, false, false, propertyList, "CIM_MediaPresent", "CIM_StorageExtent");
    }

    private static CIMInstance fetchDiskFirmware(CIMOMHandle client, CIMObjectPath diskObjectPath) throws CIMException {
        CIMInstance instance = SmisUtil.associatorInstance(client, diskObjectPath, false, false, new String[]{"VersionString"}, "CIM_ElementSoftwareIdentity", "CIM_SoftwareIdentity");
        SmisUtil.printClientCIMObjectPaths(client, diskObjectPath, "fetchDiskFirmware");
        return instance;
    }

    public static CIMInstance associatorInstance(CIMOMHandle client, CIMObjectPath objectPath, boolean includeQualifiers, boolean includeClassOrigin, String[] propertyList, String ... args) throws CIMException {
        if (args == null || args.length < 2) {
            return null;
        }
        String assocClass = args[0];
        String resultClass = args[1];
        Enumeration<CIMInstance> enumInstanaces = SmisUtil.associateInstances(client, objectPath, false, false, propertyList, assocClass, resultClass, null, null);
        if (!enumInstanaces.hasMoreElements()) {
            return null;
        }
        return enumInstanaces.nextElement();
    }

    public static CIMInstance associatorInstance(CIMOMHandle client, CIMObjectPath objectPath, String assocClass, String resultClass, String[] propertyList) throws CIMException {
        return SmisUtil.associatorInstance(client, objectPath, false, false, propertyList, assocClass, resultClass);
    }

    private static CIMInstance fetchDiskPhysicalPackageInfo(CIMOMHandle client, CIMObjectPath diskObjectPath) throws CIMException {
        String[] propertyList = new String[]{"Manufacturer", "Model", "SerialNumber"};
        return SmisUtil.associatorInstance(client, diskObjectPath, false, false, propertyList, "CIM_Realizes", "CIM_PhysicalPackage");
    }

    public static Map<String, Object> fetchArrayBasicInfo(CIMOMHandle client, CIMObjectPath storageSystemObjPath) throws CIMException {
        LOGGER.info((Object)"into fetchArrayBasicInfo", 90160777658372L);
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (null == client) {
            return results;
        }
        CIMInstance arrayInstance = client.getInstance(storageSystemObjPath, true, false, false, null);
        if (null == arrayInstance) {
            return null;
        }
        SmisUtil.cimInstanceToMap(arrayInstance, results);
        CIMInstance modelInstance = SmisUtil.fetchArrayPhysicalPackage(client, storageSystemObjPath);
        if (null == modelInstance) {
            return results;
        }
        SmisUtil.cimInstanceToMap(modelInstance, results);
        String[] propertyList = new String[]{"IdentifyingNumber", "Version", "Vendor"};
        CIMInstance instance = SmisUtil.associatorInstance(client, modelInstance.getObjectPath(), "CIM_ProductPhysicalComponent", "CIM_Product", propertyList);
        SmisUtil.cimInstanceToMap(instance, results);
        CIMInstance statusInstance = null;
        if (null == results.get("OperationalStatus")) {
            String[] propertyStatusList = new String[]{"OperationalStatus", "StatusDescriptions", "Status"};
            statusInstance = client.getInstance(storageSystemObjPath, false, false, false, propertyStatusList);
        }
        if (null != statusInstance) {
            LOGGER.info((Object)"fetchArrayBasicInfo statusInstance=", 90160777658372L);
            SmisUtil.cimInstanceToMap(statusInstance, results);
        }
        LOGGER.info((Object)"out fetchArrayBasicInfo", 90160777658372L);
        return results;
    }

    public static List<Map<String, Object>> fetchArrayBasicInfo(SmisConnection conn) throws CIMException {
        LOGGER.info((Object)"into fetchArrayBasicInfo", 90160777658372L);
        if (null == conn || !conn.isValid()) {
            throw new CIMException("Connection is invalid");
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        Map<String, CIMObjectPath> paths = conn.getArraySystemCop();
        if (null == paths) {
            return results;
        }
        Iterator<Map.Entry<String, CIMObjectPath>> iterator = paths.entrySet().iterator();
        CIMOMHandle client = conn.getCIMClientProxy();
        while (iterator.hasNext()) {
            Map.Entry<String, CIMObjectPath> entry = iterator.next();
            CIMObjectPath path = entry.getValue();
            String key = entry.getKey();
            SmisUtil.printClientCIMObjectPaths(client, path, "fetchArrayBasicInfo");
            Map<String, Object> basicInfoMap = SmisUtil.fetchArrayBasicInfo(client, path);
            if (VerifyUtil.isEmpty(basicInfoMap)) continue;
            String sn = SmisUtil.getStringValue(basicInfoMap, "IdentifyingNumber");
            if (VerifyUtil.isEmpty((String)sn) || key.indexOf(sn) < 0) {
                LOGGER.warn((Object)("The objectpath key(=" + key + ") donot equals with IDENTIFYING_NUMBER(" + sn + ")"), 90160777658372L);
                basicInfoMap.put("IC_SN", key);
            }
            results.add(basicInfoMap);
        }
        LOGGER.info((Object)("out fetchArrayBasicInfo results.size=" + results.size()), 90160777658372L);
        return results;
    }

    public static void cimInstanceToMap(CIMInstance instance, Map<String, Object> map) {
        if (null == instance || null == map) {
            return;
        }
        Vector props = instance.getProperties();
        for (CIMProperty prop : props) {
            CIMValue value = prop.getValue();
            if (value == null || value.isNull()) continue;
            map.put(prop.getName(), value);
        }
    }

    public static CIMInstance fetchArrayPhysicalPackage(CIMOMHandle client, CIMObjectPath storageSystemObjPath) {
        String[] propertyList = new String[]{"Model"};
        try {
            return SmisUtil.associatorInstance(client, storageSystemObjPath, "CIM_SystemPackaging", "CIM_PhysicalPackage", propertyList);
        }
        catch (CIMException e) {
            LOGGER.error((Object)e, 90160758784001L);
            return null;
        }
    }
}

