/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.protocol.tlv.constant;

import com.huawei.ism.cbb.proxy.protocol.tlv.constant.ParamType;
import com.huawei.ism.cbb.proxy.protocol.tlv.exception.TLVException;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.IsmInteger;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt16;
import com.huawei.ism.cbb.proxy.protocol.tlv.lang.UnsignedInt64;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.DataPackage;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.MessageHead;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Param;
import com.huawei.ism.cbb.proxy.protocol.tlv.msg.Record;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class TLVUtils {
    private static final int LOGIC_AND_CONSTANT_F = 15;
    private static final int LOGIC_AND_CONSTANT_FFF = 4095;
    private static final short NODEID = -3;
    private static Log logger = LogFactory.getInstance(TLVUtils.class);

    private TLVUtils() {
    }

    public static DataPackage param2DP(long cmdWord, String sessionKey, List<Param> tlvParams) {
        logger.debug((Object)"param2DP");
        DataPackage dp = new DataPackage();
        MessageHead head = new MessageHead();
        if (cmdWord == 8596529152L || null == sessionKey) {
            head.setSessionKey(0);
        } else {
            head.setSessionKey(NumberUtil.convertToInteger((Object)sessionKey).intValue());
        }
        head.setVersion(3);
        head.setOperationCode(cmdWord);
        head.setNodeId((short)-3);
        dp.setHead(head);
        Record record = new Record();
        record.setMsgCode(cmdWord);
        if (null != tlvParams) {
            for (Param param : tlvParams) {
                record.add(param);
            }
        }
        dp.addRecord(record);
        return dp;
    }

    public static List<Param> addParam(List<Param> tlvParams, Param ... publicParams) {
        logger.debug((Object)"addParam");
        ArrayList<Param> returnParams = new ArrayList<Param>(tlvParams.size() + publicParams.length);
        for (int i = 0; i < publicParams.length; ++i) {
            Param param = publicParams[i];
            returnParams.add(param);
        }
        for (Param param : tlvParams) {
            boolean exist = false;
            for (int i = 0; i < publicParams.length; ++i) {
                if (param.getIndex() != publicParams[i].getIndex()) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            returnParams.add(param);
        }
        return returnParams;
    }

    public static List<Param> singleItemList(int tag, ParamType type, Object value) {
        logger.debug((Object)"singleItemList");
        Param tlvParam = TLVUtils.newParam(tag, type, value);
        ArrayList<Param> dataList = new ArrayList<Param>(1);
        dataList.add(tlvParam);
        return dataList;
    }

    public static List<Param> singleItemList(Param tlvParam) {
        logger.debug((Object)"singleItemList");
        ArrayList<Param> dataList = new ArrayList<Param>(1);
        dataList.add(tlvParam);
        return dataList;
    }

    private static Param newParam(int tag, ParamType type, Object value) {
        logger.debug((Object)"newParam");
        if (value instanceof String) {
            return new Param(tag, type, (String)value);
        }
        if (value instanceof IsmInteger) {
            return new Param(tag, type, (IsmInteger)value);
        }
        throw new IllegalArgumentException("value must be a String or IsmInteger Object");
    }

    public static boolean containTag(Record data, int tag) {
        logger.debug((Object)"containTag");
        for (Param param : data.getParams()) {
            if (param.getIndex() != tag) continue;
            return true;
        }
        return false;
    }

    public static DataPackage decode(byte[] msgData) {
        logger.debug((Object)"decode");
        MessageHead head = new MessageHead(msgData);
        long retValue = head.getStatus();
        if (retValue != 0L) {
            throw new TLVException(retValue);
        }
        DataPackage dp = new DataPackage();
        dp.setHead(head);
        List<Record> recvDataList = TLVUtils.decode2Records(msgData, 28);
        dp.setRecordset(recvDataList);
        return dp;
    }

    private static List<Record> decode2Records(byte[] msgData, int headLength) {
        logger.debug((Object)"decode2Records");
        ByteArrayInputStream baiStream = new ByteArrayInputStream(msgData);
        long skip = baiStream.skip(headLength);
        if (skip != (long)headLength) {
            throw new TLVException(100664548L);
        }
        ArrayList<Record> recvDataList = new ArrayList<Record>();
        while (baiStream.available() > 0) {
            long msgCode = new UnsignedInt64(TLVUtils.readBytes(baiStream, 8)).longValue();
            short recordLength = new UnsignedInt16(TLVUtils.readBytes(baiStream, 2)).shortValue();
            byte[] recordBytes = TLVUtils.readBytes(baiStream, recordLength);
            Record recvData = TLVUtils.decodeToRecord(recordBytes);
            List paramList = recvData.getParams();
            if (paramList.isEmpty()) continue;
            recvData.setMsgCode(msgCode);
            recvDataList.add(recvData);
        }
        return recvDataList;
    }

    private static byte[] readBytes(InputStream is, int length) {
        logger.debug((Object)"readBytes");
        byte[] bytes = new byte[length];
        if (length == 0) {
            return bytes;
        }
        try {
            int readLength = is.read(bytes);
            if (readLength != length) {
                logger.error((Object)("readLength=" + readLength + ", length=" + length));
                throw new IllegalStateException("");
            }
        }
        catch (IOException e) {
            throw new TLVException(16797698L, (Throwable)e);
        }
        return bytes;
    }

    private static Record decodeToRecord(byte[] recordBytes) {
        logger.debug((Object)"decodeToRecord");
        ByteArrayInputStream baiStream = new ByteArrayInputStream(recordBytes);
        Record recvData = new Record();
        while (baiStream.available() > 0) {
            short typeCmo = new UnsignedInt16(TLVUtils.readBytes(baiStream, 2)).shortValue();
            short paramTypeValue = (short)(typeCmo & 0xF);
            ParamType paramType = ParamType.getParamType((int)paramTypeValue);
            short index = (short)(typeCmo >> 4 & 0xFFF);
            short paramLength = new UnsignedInt16(TLVUtils.readBytes(baiStream, 2)).shortValue();
            byte[] tlvBytes = TLVUtils.readBytes(baiStream, paramLength);
            Param param = new Param((int)index, paramType, tlvBytes);
            if (index == 4095) {
                if (paramType == ParamType.STRING) {
                    throw new TLVException(param.stringValue());
                }
                if (paramType == ParamType.UNSIGN_INT && param.longValue() != 1L) {
                    throw new TLVException(param.longValue());
                }
            }
            recvData.add(param);
        }
        return recvData;
    }
}

