/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service;

import com.huawei.ism.ArrayPackageActivator;
import com.huawei.ism.cbb.proxy.indication.IndicationMonitor;
import com.huawei.ism.cbb.util.IsmBeanUtils;
import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.connection.smis.ConnectionManager;
import com.huawei.ism.notification.IChangeTaker;
import com.huawei.ism.notification.NotificationManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.UIManager;

public final class FrameworkInitializer {
    public static final String MAIN_ARG_ACCOUNT = "";
    public static final String MAIN_ARG_PWD = "";
    public static final String MAIN_ARG_IP = "";
    public static final String INIT_STRING = "";
    private static final Log logger = LogFactory.getInstance(FrameworkInitializer.class);

    private FrameworkInitializer() {
    }

    public static synchronized void initializeDevice(String deviceId) {
        ConnectionManager manager = ConnectionManager.getInstance();
        if (!manager.isExistConnection(deviceId)) {
            logger.error((Object)("No connection with device id : " + deviceId + " existed !"), 90160777658902L);
            return;
        }
        Connection connection = manager.getConnectionByArrayId(deviceId);
        Collection ips = connection.getManagerIPs();
        User user = connection.getUser();
        Launcher launcher = FrameworkInitializer.createLauncher(connection.getDeviceType(), user, ips.toArray(new String[ips.size()]), deviceId, connection.getCurrentIP());
        launcher.setDeviceTimeZone(TimeZone.getDefault());
        LauncherManager launcherManager = LauncherManager.getInstance();
        Map mapOfDeviceInfo = null;
        try {
            mapOfDeviceInfo = (Map)IsmBeanUtils.forceGetProperty((Object)launcherManager, (String)"_mapOfDeviceInfo");
        }
        catch (NoSuchFieldException e1) {
            logger.error((Object)"force get v1 launcher info failed", 90160777658902L);
        }
        if (null != mapOfDeviceInfo) {
            mapOfDeviceInfo.put(connection.getArrayId(), launcher);
        }
        String[] ipStrings = ips.toArray(new String[ips.size()]);
        DeviceContext context = new DeviceContext(user, ipStrings);
        try {
            context.setDeviceType(DeviceType.valueOf((String)connection.getDeviceType()));
            IsmBeanUtils.forceSetProperty((Object)launcher, (String)"devContext", (Object)context);
        }
        catch (NoSuchFieldException e) {
            logger.info((Object)"force set v1 device context info failed", 90160777658902L);
        }
        try {
            IsmBeanUtils.forceSetProperty((Object)launcher, (String)"connection", (Object)connection);
            IsmBeanUtils.forceSetProperty((Object)launcher, (String)"loginUser", (Object)user);
            launcher.getDevContext().setDeviceID(null);
            launcher.getDeviceID();
        }
        catch (Exception e) {
            context.setDeviceID(connection.getArrayId());
            logger.error((Object)("Get device ID error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
        }
    }

    private static Launcher createLauncher(String deviceType, User user, String[] ips, String deviceID, String ip) {
        DeviceContext deviceContext = new DeviceContext(user, ips);
        deviceContext.setDeviceID(deviceID);
        deviceContext.setConnectionIP(ip);
        deviceContext.setDeviceType(DeviceType.getDeviceType((String)deviceType));
        if (DeviceType.N8000.name().equals(deviceType)) {
            throw new LegoCheckedException(127402L);
        }
        Launcher launcher = new ArrayPackageActivator().createLauncher(deviceType);
        launcher.start(deviceContext, null);
        return launcher;
    }

    static {
        try {
            UIManager.put("IsmTable.rowHeight", 10);
            Framework.getInstance().setProperty("RUN_MODE", (Object)"PROXY");
            Framework.getInstance().setProperty("NOT_CONFIG_LOG4J", (Object)"true");
            Framework.getInstance().setProperty("-account", (Object)"");
            Framework.getInstance().setProperty("-password", (Object)"");
            Framework.getInstance().setProperty("-ip", (Object)"");
            Framework.getInstance().init("");
            NotificationManager.getInstance().setIsmChangeTaker((IChangeTaker)IndicationMonitor.getMonitor());
            logger.info((Object)"Initialized v1 framework !", 90160777658901L);
        }
        catch (Exception e) {
            logger.error((Object)("Initialize v1 framework failed !" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
        }
    }
}

