/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.proxy.indication.CIMIndicationListenerImpl;
import com.huawei.ism.cbb.proxy.service.FrameworkInitializer;
import com.huawei.ism.cbb.proxy.service.IConnectionManager;
import com.huawei.ism.cbb.proxy.service.UserEntity;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.util.WbemUtil;
import com.huawei.ism.connection.smis.CIMExceptionHandler;
import com.huawei.ism.connection.smis.CIMListenerImpl;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.ism.connection.smis.ConnectionBase;
import com.huawei.ism.connection.smis.ConnectionManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.notification.NotificationManager;
import com.huawei.ism.proxy.ProxyFactory;
import com.huawei.ism.proxy.UserInterface;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public final class ConnectionManagerSmisImpl
implements IConnectionManager {
    private static final Log logger = LogFactory.getInstance(ConnectionManagerSmisImpl.class);
    private static final String SSL_ENABLE_FLAG = "1";

    @Override
    public StorageNE connect(List<String> manageIps, NeMgrProtocolExtend neMgrProtocolExtend) {
        StorageNE storageNE;
        try {
            Connection connection = ConnectionManagerSmisImpl.authenticateAndBuildConnection(manageIps, neMgrProtocolExtend);
            if (connection == null) {
                return null;
            }
            storageNE = ConnectionManagerSmisImpl.getDeviceBasicInfo(connection);
            if (null == storageNE) {
                return null;
            }
            String devSn = storageNE.getSn();
            ConnectionManager manager = ConnectionManager.getInstance();
            if (manager.isExistConnection(devSn)) {
                logger.info((Object)("Remove the existed connection. DevSN:" + devSn), 90160758784000L);
                manager.stopHeartbeat(devSn);
                manager.removeConnectionByArrayId(devSn);
            }
            manager.manageConnecton(devSn, connection, (CIMListenerImpl)new CIMIndicationListenerImpl(devSn));
            FrameworkInitializer.initializeDevice(devSn);
            NotificationManager.getInstance().loadSubscriptTypes(devSn, new NotificationManager.SubscriptType[]{NotificationManager.SubscriptType.ALL});
        }
        catch (LegoCheckedException ex) {
            logger.error((Object)"Connection to storage failes.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)("Connection to storage failes." + ExceptionUtil.getErrorMessage((Throwable)ex)));
            throw new LegoCheckedException(1073947649L, (Throwable)ex);
        }
        return storageNE;
    }

    public static Connection authenticateAndBuildConnection(List<String> manageIps, NeMgrProtocolExtend neMgrProtocolExtend) {
        Connection connection;
        User user = new User(neMgrProtocolExtend.getNetworkUserName(), neMgrProtocolExtend.getNetworkPassword());
        String availableIp = null;
        Map extendParams = neMgrProtocolExtend.getExtendParams();
        DeviceContext.ProtocalType protocalType = ConnectionManagerSmisImpl.getHttpType(extendParams);
        Long errorCode = null;
        for (String ip : manageIps) {
            try {
                user.setSessionKey("0");
                WbemUtil.authenticateUser((DeviceContext.ProtocalType)protocalType, (String)ip, (User)user, (boolean)Boolean.TRUE);
                availableIp = ip;
                break;
            }
            catch (IsmException e) {
                logger.error((Object)e.getMessage(), (Throwable)e, 90160777658902L);
                if (e.getErrorId() == 0x500050DL) {
                    try {
                        user = new UserEntity(neMgrProtocolExtend.getNetworkUserName(), WccEncryptor.encrypt((String)neMgrProtocolExtend.getNetworkPassword()));
                        WbemUtil.authenticateUser((DeviceContext.ProtocalType)protocalType, (String)ip, (User)user, (boolean)Boolean.FALSE);
                        availableIp = ip;
                    }
                    catch (IsmException e1) {
                        errorCode = e1.getErrorId();
                        logger.error((Object)("The exception errorCode is:" + errorCode), 90160777658902L);
                    }
                    break;
                }
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException ie) {
                    logger.error((Object)ie.getMessage(), (Throwable)ie, 90160777658902L);
                }
            }
            catch (Exception e) {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 90160777658902L);
                try {
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (InterruptedException ie) {
                    logger.error((Object)ie.getMessage(), (Throwable)ie, 90160777658902L);
                }
            }
        }
        if (availableIp == null) {
            logger.error((Object)"No available ip to build connection for device : ", 90160777658902L);
            if (null == errorCode) {
                errorCode = 104403L;
            }
            throw new LegoCheckedException(errorCode.longValue());
        }
        try {
            connection = ConnectionManager.getInstance().buildConnectionBy(availableIp, user, protocalType);
        }
        catch (Exception e) {
            logger.error((Object)("Exception :" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
            connection = null;
        }
        return connection;
    }

    private static DeviceContext.ProtocalType getHttpType(Map<String, String> extendParams) {
        DeviceContext.ProtocalType protocalType = DeviceContext.ProtocalType.HTTP;
        if (null != extendParams && SSL_ENABLE_FLAG.equals(extendParams.get("sslFlag"))) {
            protocalType = DeviceContext.ProtocalType.HTTPS;
        }
        return protocalType;
    }

    public static StorageNE getDeviceBasicInfo(Connection connection) {
        StorageNE storageNE = null;
        try {
            String productVersion;
            CIMInstance deviceInstance = WbemUtil.getComputerSystem((ConnectionBase)connection);
            HashMap arrayProperties = WbemUtil.assembleProperties((CIMInstance)deviceInstance);
            Object[] resultArray = WbemUtil.getStrArrayProperty((HashMap)arrayProperties, (String)"OtherIdentifyingInfo");
            if (VerifyUtil.isEmpty((Object[])resultArray)) {
                logger.error((Object)"GET deviceId ERROR: resultArray is empty.", 90160777658902L);
                return null;
            }
            Object deviceId = resultArray[0];
            String uuid = WbemUtil.getStrProperty((HashMap)arrayProperties, (String)"Name");
            int productModelValue = WbemUtil.getUintProperty((HashMap)arrayProperties, (String)"ProductModel", (Number)-1).intValue();
            ProductModelType productModelType = ProductModelType.getProductModel((int)productModelValue);
            try {
                productVersion = WbemUtil.getStrProperty((HashMap)arrayProperties, (String)"ProductVersion", (String)"--");
            }
            catch (Exception e) {
                logger.error((Object)("GET productVersion ERROR: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
                productVersion = null;
            }
            connection.setArrayId((String)deviceId);
            connection.setArrayUuid(uuid);
            connection.setDeviceType(productModelType.getDeviceType().name());
            storageNE = new StorageNE();
            storageNE.setSn((String)deviceId);
            storageNE.setLinkIp(connection.getCurrentIP());
            storageNE.setIpAddress(connection.getCurrentIP());
            storageNE.setProductModel(productModelType.name());
            storageNE.setSubType(productModelType.toString());
            if (DeviceType.S2600.equals((Object)productModelType.getDeviceType()) && "--".equals(productVersion)) {
                storageNE.setProductModel("S2600V1R2");
                storageNE.setSubType("S2600(V100R002)");
            }
            storageNE.setUuid(uuid);
            storageNE.setVersion(productVersion);
        }
        catch (Exception ex) {
            logger.error((Object)("getDeviceBasicInfo ERROR: " + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658902L);
        }
        return storageNE;
    }

    @Override
    public Connection getConnection(String devSN) {
        if (this.isConnected(devSN)) {
            return ConnectionManager.getInstance().getConnectionByArrayId(devSN);
        }
        return null;
    }

    @Override
    public boolean isConnected(String devSN) {
        ConnectionManager manager = ConnectionManager.getInstance();
        if (!manager.isExistConnection(devSN)) {
            return false;
        }
        Connection connection = manager.getConnectionByArrayId(devSN);
        if (!connection.isConnected()) {
            return false;
        }
        CIMObjectPath userServicePath = new CIMObjectPath("ISM_AccountManagementService");
        CIMArgument[] arg1 = new CIMArgument[1];
        CIMArgument[] arg2 = new CIMArgument[1];
        try {
            connection.invokeMethod(userServicePath, "HandShake", arg1, arg2, 30);
            return true;
        }
        catch (CIMException ex) {
            IsmException ismE = CIMExceptionHandler.cimException2IsmException((CIMException)ex);
            long errorId = ismE.getErrorId();
            logger.error((Object)("Exception while SMI-S handshake, devSn=" + devSN + ", ip=" + connection.getCurrentIP() + ";errorId:" + errorId), 90160777658902L);
        }
        catch (Exception ex) {
            logger.error((Object)("Exception while SMI-S handshake: " + devSN + ", ip=" + connection.getCurrentIP() + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160777658902L);
        }
        return false;
    }

    @Override
    public void removeConnection(String devSN) {
        if (this.isConnected(devSN)) {
            try {
                this.logoutArray(devSN);
            }
            catch (Exception e) {
                logger.error((Object)("Exception : " + devSN + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658902L);
            }
            finally {
                ConnectionManager.getInstance().removeConnectionByArrayId(devSN);
            }
        }
    }

    private void logoutArray(String arrayId) {
        Connection connection = ConnectionManager.getInstance().getConnectionByArrayId(arrayId);
        User user = connection.getUser();
        UserInterface userIF = (UserInterface)ProxyFactory.getProxy((String)connection.getDeviceType(), (String)"UserInterface");
        try {
            userIF.logoutArray(user, arrayId);
        }
        catch (IsmException e) {
            logger.error((Object)"logout array user failed.", (Throwable)e);
        }
    }
}

