/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.proxy.service.IDevProtocolCollect;
import com.huawei.ism.cbb.proxy.service.IDevProtocolCollectExtender;
import com.huawei.ism.cbb.proxy.service.impl.ConnectionManagerSmisImpl;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.connection.smis.Connection;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

public class SmisProtocolCollect
implements IDevProtocolCollect {
    private static final String SYS_OID_DEFAULT = "huawei-storage-default";
    private static final String MANAGEMENT_PROTOCOL_TYPE_DEFAULT = "SMI-S";
    private final Log logger = LogFactory.getInstance(this.getClass());
    private final Map<String, IDevProtocolCollectExtender> extenders = new HashMap<String, IDevProtocolCollectExtender>();

    @Override
    public boolean collectInfo(DiscoveryPolicy discoveryPolicy, Map<String, String> extendParam) {
        boolean isCollectInfo = this.collectInfo(discoveryPolicy, extendParam, "1");
        if (!isCollectInfo) {
            isCollectInfo = this.collectInfo(discoveryPolicy, extendParam, "0");
        }
        return isCollectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean collectInfo(DiscoveryPolicy discoveryPolicy, Map<String, String> extendParam, String sslFlag) {
        ArrayList<String> manageIps = new ArrayList<String>();
        manageIps.add(discoveryPolicy.getStartIP());
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(discoveryPolicy.getStartIP());
        Map paramMap = discoveryPolicy.getParamMap();
        neMgrExtend.setNetworkUserName((String)paramMap.get("name"));
        neMgrExtend.setNetworkPassword((String)paramMap.get("password"));
        neMgrExtend.getExtendParams().put("sslFlag", sslFlag);
        Connection conn = null;
        try {
            conn = ConnectionManagerSmisImpl.authenticateAndBuildConnection(manageIps, neMgrExtend);
            StorageNE storageNe = ConnectionManagerSmisImpl.getDeviceBasicInfo(conn);
            if (null != storageNe) {
                this.updateExtendParam(extendParam, storageNe, sslFlag);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("SMI-S collect failed, ssl=" + sslFlag + ", ip=" + (String)manageIps.get(0) + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
        }
        finally {
            this.logout(conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logout(Connection connection) {
        if (null == connection) {
            return;
        }
        User user = connection.getUser();
        try {
            CIMObjectPath userServicePath = new CIMObjectPath("ISM_AccountManagementService");
            CIMArgument arg = new CIMArgument("Name", new CIMValue((Object)user.getUserName()));
            CIMArgument arg2 = new CIMArgument("UserAddressinfo", new CIMValue((Object)user.getLocalUserAddressinfo()));
            CIMArgument[] ins = new CIMArgument[]{arg, arg2};
            CIMArgument[] outs = new CIMArgument[]{};
            connection.invokeMethod(userServicePath, "Logout", ins, outs);
        }
        catch (CIMException e) {
            this.logger.error((Object)"UserProxy logoutArray() Error!", (Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception e) {
                this.logger.error((Object)("Connection close error," + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private void updateExtendParam(Map<String, String> extendParam, StorageNE storageNe, String sslFlag) {
        extendParam.put("protocol", "DEFAULT");
        boolean isExtendDevice = false;
        for (Map.Entry<String, IDevProtocolCollectExtender> next : this.extenders.entrySet()) {
            Map<String, String> temp = next.getValue().getExtendParam(storageNe);
            if (VerifyUtil.isEmpty(temp)) continue;
            extendParam.putAll(temp);
            isExtendDevice = true;
            break;
        }
        if (!isExtendDevice) {
            extendParam.put("sysOid", SYS_OID_DEFAULT);
            extendParam.put("managementProtocol", MANAGEMENT_PROTOCOL_TYPE_DEFAULT);
        }
        extendParam.put("ssl", sslFlag);
    }

    public void onBind(IDevProtocolCollectExtender extender, Map<String, String> properties) {
        List<String> protocols = extender.getProtocols();
        if (VerifyUtil.isEmpty(protocols)) {
            return;
        }
        this.logger.info((Object)("extender device type:" + extender.getManagementProtocolType()));
        for (String protocol : protocols) {
            if (!this.getProtocolName().equals(protocol)) continue;
            this.extenders.put(extender.getManagementProtocolType(), extender);
            this.logger.info((Object)("Add SMI-S protocol extender, deviceType=" + extender.getManagementProtocolType()), 90160758784000L);
            break;
        }
    }

    public void unBind(IDevProtocolCollectExtender extender, Map<String, String> properties) {
        List<String> protocols = extender.getProtocols();
        if (VerifyUtil.isEmpty(protocols)) {
            return;
        }
        for (String protocol : protocols) {
            if (!this.getProtocolName().equals(protocol)) continue;
            this.extenders.remove(extender.getManagementProtocolType());
            this.logger.info((Object)("Remove SMI-S protocol extender, deviceType=" + extender.getManagementProtocolType()), 90160758784000L);
            break;
        }
    }

    @Override
    public String getProtocolName() {
        return MANAGEMENT_PROTOCOL_TYPE_DEFAULT;
    }
}

