/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.xve.ConnectionManagerTlvImpl;
import com.huawei.ism.cbb.proxy.service.IDevProtocolCollect;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.Map;

public class TlvProtocolCollect
implements IDevProtocolCollect {
    private static final String SYS_OID_TLV = "huawei-storage-tlv";
    private static final String MANAGEMENT_PROTOCOL_TYPE_TLV = "TLV";
    private static final Log LOGGER = LogFactory.getInstance(TlvProtocolCollect.class);

    @Override
    public String getProtocolName() {
        return MANAGEMENT_PROTOCOL_TYPE_TLV;
    }

    @Override
    public boolean collectInfo(DiscoveryPolicy discoveryPolicy, Map<String, String> extendParam) {
        NeMgrProtocolExtend neMgrExtend = new NeMgrProtocolExtend();
        neMgrExtend.setNetworkIpAddress(discoveryPolicy.getStartIP());
        Map paramMap = discoveryPolicy.getParamMap();
        neMgrExtend.setNetworkUserName((String)paramMap.get("name"));
        neMgrExtend.setNetworkPassword((String)paramMap.get("password"));
        neMgrExtend.getExtendParams().put("sslFlag", "1");
        try {
            ConnectionManagerTlvImpl.validate(neMgrExtend);
            this.updateExtendParam(extendParam);
            return true;
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"storage protocol tlv try failed.", (Throwable)ex, 90160758784000L);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("storage protocol tlv try failed." + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758784000L);
        }
        return false;
    }

    private void updateExtendParam(Map<String, String> extendParam) {
        extendParam.put("sysOid", SYS_OID_TLV);
        extendParam.put("managementProtocol", MANAGEMENT_PROTOCOL_TYPE_TLV);
        extendParam.put("protocol", "DEFAULT");
    }
}

