/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.proxy.util;

import com.huawei.lego.com.south.sdk.model.LegoSnmpOID;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVar;
import com.huawei.lego.com.south.sdk.model.LegoSnmpVarBind;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.math.BigInteger;

public final class LegoSnmpUtil {
    private static final Log LOGGER = LogFactory.getInstance(LegoSnmpUtil.class);

    private LegoSnmpUtil() {
    }

    public static String getOID(LegoSnmpVarBind varBind) {
        LegoSnmpOID oidObject = varBind.getSnmpoid();
        return oidObject.getSnmpoid();
    }

    public static String getValueString(LegoSnmpVarBind varBind) {
        LegoSnmpVar var = varBind.getSnmpvar();
        SnmpEnum.SnmpType valueType = var.getValtype();
        String value = var.getSnmpval();
        try {
            if (SnmpEnum.SnmpType.INTEGER.equals((Object)valueType)) {
                return Integer.valueOf(value).toString();
            }
            if (SnmpEnum.SnmpType.COUNTER.equals((Object)valueType)) {
                return Long.valueOf(value).toString();
            }
            if (SnmpEnum.SnmpType.COUNTER64.equals((Object)valueType)) {
                return new BigInteger(value).toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to convert SnmpVar to String" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784512L);
        }
        return value;
    }
}

