/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.process.AbstractPingProcessor;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.SecurityUtil;

public class HVSRestPingProcessor
extends AbstractPingProcessor {
    private static final Log logger = LogFactory.getInstance(HVSRestPingProcessor.class);

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getCurrentIp(String sn) {
        return HvsRestConnectionManager.getInstance().getExistConnection(sn).filter(RestConnection::isValid).map(RestConnection::getIpAddress).orElse(null);
    }

    protected void connect(String sn, String ip, NeMgrProtocolExtend info) {
        String username = info.getNetworkUserName();
        String password = info.getNetworkPassword();
        int port = NumberUtil.parseInteger(info.getExtendParams().get("port"));
        HvsRestConnectionManager connectionManager = HvsRestConnectionManager.getInstance();
        HvsRestConnection connection = connectionManager.buildConnection(ip, port, username, password);
        if (!sn.equals(connection.getDeviceId())) {
            logger.error((Object)"SN match fail, db devSn=%s, but realtime devSn=%s with the ip=%s", new Object[]{SecurityUtil.desensitizeId((String)sn), SecurityUtil.desensitizeId((String)connection.getDeviceId()), ip});
            throw new LegoCheckedException(1073947432L);
        }
        connectionManager.putConnection(connection);
    }
}

