/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.process;

import com.huawei.ism.array.sdk.model.ArrayUnit;
import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.cbb.discover.array.ArrayDiscoverUtil;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.util.StringUtil;
import com.huawei.ism.cbb.util.TimeUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.util.ManagedObjectUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.ubase.adaptor.hvs.discovery.process.HVSDeviceProxyImpl;
import java.util.List;
import java.util.TimeZone;

public class RetrieveHVSInfoProcessor
implements IProcessor {
    private final Log logger = LogFactory.getInstance((Object)this);

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext context) {
    }

    public boolean process(AbstractContext context) {
        HvsStorage storageDevice = (HvsStorage)context.getAttribute("StorageDevice");
        if (null == storageDevice) {
            this.logger.error((Object)"storageDevice is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = (RestConnection)HvsRestConnectionManager.getInstance().getConnectionOptional(storageDevice.getSn()).orElseThrow(() -> new LegoCheckedException(104401L));
        HVSDeviceProxyImpl deviceProxy = new HVSDeviceProxyImpl();
        HvsUnit hvsUnit = deviceProxy.getComputerSystem(connection);
        HvsStorage hvsStorage = new HvsStorage();
        this.processStorage(hvsStorage, hvsUnit);
        deviceProxy.getControllers(connection, hvsUnit);
        List<XveStoragePool> storagePools = deviceProxy.getStoragePools(connection, hvsUnit);
        List<VstoreInfo> vStoreInfos = deviceProxy.getVStoreInfos(connection, hvsUnit);
        List<XveLun> xveLuns = deviceProxy.getLuns(connection, hvsUnit.getDevSn(), storagePools);
        this.processFileSystem(connection, deviceProxy, hvsUnit.getDevSn(), storagePools, null);
        try {
            deviceProxy.getLogicInterfaces(connection, hvsUnit);
        }
        catch (Exception e) {
            this.logger.error((Object)("Geting logic interfaces failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        deviceProxy.getMappingViews(connection, hvsUnit);
        deviceProxy.getHosts(connection, hvsUnit);
        deviceProxy.getInitiators(connection, hvsUnit);
        deviceProxy.getArrayHostGroups(connection, hvsUnit);
        deviceProxy.getXveLunGroups(connection, hvsUnit);
        deviceProxy.getXvePortGroups(connection, hvsUnit);
        TimeZone timeZone = deviceProxy.getSystemTimeZoneInfo(connection);
        String timezoneFormat = TimeUtil.getTimeZoneOffset((TimeZone)timeZone);
        hvsStorage.setTimezoneFormat(timezoneFormat);
        hvsUnit.setTimezoneFormat(timezoneFormat);
        this.processIps(connection, deviceProxy, hvsStorage, hvsUnit);
        hvsStorage.setTotalLunCap(Double.valueOf(ArrayDiscoverUtil.getTotalLunCap(xveLuns)));
        hvsStorage.setTotalLunCapUnit(CapabilityUnitType.MB.name());
        hvsStorage.setMappedLunCap(Double.valueOf(ArrayDiscoverUtil.getMappedLunCap(xveLuns)));
        hvsStorage.setMappedLunCapUnit(CapabilityUnitType.MB.name());
        context.setAttribute("ArrayUnit", (Object)hvsUnit);
        context.setAttribute("StorageArray", (Object)hvsStorage);
        context.setAttribute("ArrayVstore", vStoreInfos);
        return true;
    }

    private void processStorage(HvsStorage hvsStorage, HvsUnit hvsUnit) {
        hvsStorage.setSn(hvsUnit.getDevSn());
        hvsStorage.setManagementProtocol("REST");
        hvsStorage.setArrayUnit((ArrayUnit)hvsUnit);
        hvsStorage.setIpAddress(hvsUnit.getLinkIp());
        hvsStorage.setUuid("HvsStorage" + hvsUnit.getDevSn());
        hvsStorage.setIsTopMo(Boolean.valueOf(true));
        hvsStorage.setManaged(Boolean.valueOf(true));
        hvsStorage.setManufacturer("Huawei Technologies Co., Ltd.");
        hvsStorage.addChildMo((ManagedObject)hvsUnit);
        hvsUnit.setParentMo((ManagedObject)hvsStorage);
        hvsUnit.setTopMoUuid(hvsStorage.getUuid());
    }

    private void processFileSystem(RestConnection connection, HVSDeviceProxyImpl proxy, String devSn, List<XveStoragePool> pools, String vstoreId) {
        List<NasFileSystem> nasFileSystemList = proxy.getFileSystem(connection, devSn, null, vstoreId);
        block0: for (NasFileSystem fileSystem : nasFileSystemList) {
            for (XveStoragePool pool : pools) {
                if (pool.getUsageType() != XveEnumDefine.STORAGEPOOL_USAGETYPE_E.FILESYSTEM.getValue() || !pool.getPoolId().equals(fileSystem.getStoragePoolId())) continue;
                ManagedObjectUtil.associate((ManagedObject)fileSystem, (ManagedObject)pool);
                continue block0;
            }
        }
    }

    private void processIps(RestConnection connection, HVSDeviceProxyImpl proxy, HvsStorage storage, HvsUnit unit) {
        if (unit.isHasSvp()) {
            storage.setManagedIps(unit.getLinkIp());
            this.logger.info((Object)("HVS device mgmt port info:" + storage.getSn() + ":" + storage.getManagedIps()), 90160777658372L);
            return;
        }
        List<String> managementIps = proxy.getManagementIps(connection);
        if (managementIps.isEmpty()) {
            storage.setManagedIps(unit.getLinkIp());
        } else {
            String ipStr = StringUtil.arrayToStrWithSplit((Object[])managementIps.toArray(new String[managementIps.size()]), (String)",");
            storage.setManagedIps(ipStr);
        }
        this.logger.info((Object)("Rest device mgmt Port info:" + storage.getSn() + ":" + storage.getManagedIps()), 90160777658372L);
    }
}

