/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ubase.adaptor.hvs.discovery.synchronizer;

import com.huawei.ism.array.sdk.model.HvsStorage;
import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.cbb.discover.util.DiscoverExUtil;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.HvsRestConnectionManager;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.util.ResourceHelper;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.ubase.adaptor.hvs.discovery.process.HVSDeviceProxyImpl;
import java.util.Arrays;
import java.util.Optional;

public class HvsStorageSynchronizer
extends AbstractSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(HvsStorageSynchronizer.class);

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter params, MoListOrMap moListOrMap) {
        if (null == params) {
            LOGGER.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.info((Object)("Begin to discover rest storage, device IP:" + params.getDeviceIp()), 90160777658372L);
        NeMgrProtocolExtend neMgrProtocolExtend = DiscoverExUtil.parseHuaweiStorageParams(params);
        if (VerifyUtil.isEmpty((Object)neMgrProtocolExtend) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkUserName()) || VerifyUtil.isEmpty((String)neMgrProtocolExtend.getNetworkPassword())) {
            throw new LegoCheckedException(1073947393L);
        }
        String restPort = (String)neMgrProtocolExtend.getExtendParams().get("port");
        if (VerifyUtil.isEmpty((String)restPort)) {
            restPort = ResourceHelper.getValue("hvs.port");
            LOGGER.info((Object)("Use default rest port, value=" + restPort), 90160758784000L);
            neMgrProtocolExtend.getExtendParams().put("port", restPort);
        }
        this.retrieveHVS(params, moListOrMap, neMgrProtocolExtend);
        return null;
    }

    private void retrieveHVS(SynchronizeParameter params, MoListOrMap moListOrMap, NeMgrProtocolExtend neMgrProtocolExtend) {
        CommonTemplate discoverTemplate = CommonTemplateManager.getInstance().getTemplateByManagementProtocol("REST", 1);
        if (null == discoverTemplate) {
            LOGGER.error((Object)"discoverTemplate is null.", 90160758784000L);
            throw new LegoCheckedException(127402L);
        }
        RestConnection connection = this.initConnection(neMgrProtocolExtend);
        HVSDeviceProxyImpl proxy = new HVSDeviceProxyImpl();
        HvsUnit hvsUnit = proxy.getComputerSystem(connection);
        HvsStorage hvsStorage = new HvsStorage();
        hvsStorage.setSn(hvsUnit.getDevSn());
        hvsStorage.setProductModel(hvsUnit.getProductModel());
        hvsStorage.setManagementProtocolMap(params.getManagementProtocolMap());
        hvsStorage.setIpAddress(params.getDeviceIp());
        hvsStorage.setLinkIp(params.getDeviceIp());
        DiscoverContext context = new DiscoverContext(params, moListOrMap);
        context.setAttribute("StorageDevice", (Object)hvsStorage);
        context.setAttribute("NeMgrProtocolExtend", (Object)neMgrProtocolExtend);
        context.setAttribute("AvailableIps", Arrays.asList(params.getDeviceIp()));
        context.setAttribute("SiteId", (Object)params.getDiscoveryPolicy().getLocation());
        context.setAttribute("OperatorId", (Object)params.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
    }

    private RestConnection initConnection(NeMgrProtocolExtend neMgrProtocolExtend) {
        HvsRestConnection connection;
        String devSn;
        String ip = neMgrProtocolExtend.getNetworkIpAddress();
        HvsRestConnectionManager connectionManager = HvsRestConnectionManager.getInstance();
        Optional<HvsRestConnection> oldConnection = connectionManager.getExistConnection(devSn = (connection = (HvsRestConnection)connectionManager.buildConnection(neMgrProtocolExtend)).getDeviceId()).filter(RestConnection::isValid);
        if (!oldConnection.isPresent()) {
            connectionManager.putConnection(connection);
            return connection;
        }
        try {
            connection.logout();
            LOGGER.info((Object)"logout success, devSn=%s, ip=%s", new Object[]{SecurityUtil.desensitizeId((String)devSn), ip});
        }
        catch (Exception ex) {
            LOGGER.error((Object)"logout failed. devSn=%s, ip=%s, message: %s", new Object[]{SecurityUtil.desensitizeId((String)devSn), ip, ExceptionUtil.getErrorMessage((Throwable)ex)});
        }
        return oldConnection.get();
    }
}

