/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.cloudservice.service;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.cloudservice.service.ICloudServiceRestservice;
import com.huawei.ism.drm.web.util.CommUtils;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.cbb.cloudservice.sdk.model.BureauInfo;
import com.huawei.lego.cbb.cloudservice.sdk.model.CloudServiceBaseInfo;
import com.huawei.lego.cbb.cloudservice.sdk.model.CloudServiceNotifyEmail;
import com.huawei.lego.cbb.cloudservice.sdk.service.IBureauService;
import com.huawei.lego.cbb.cloudservice.sdk.service.ICloudService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.SecurityUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;

public class CloudServiceRestServiceImpl
extends AbstractRestService
implements ICloudServiceRestservice {
    private static Log log = LogFactory.getInstance(CloudServiceRestServiceImpl.class);
    private static final String DEVICE_TYPE_KEY_APM = "ultraapm.base.about.title";
    private static final String PRODUCT_VERSION_KEY_APM = "ultraapm.rd.base.about.version.value";
    private static final String DEVICE_TYPE_KEY_IC = "ism.base.about.title";
    private static final String DEVICE_TYPE_KEY_LEGO = "lego.lab.com.about.sysabout";
    private static final List<Integer> LANGUAGE_BOUND = new ArrayList<Integer>(Arrays.asList(0, 1, 2));

    @Override
    public CloudServiceBaseInfo getCallhomeBasicInfo() {
        log.trace((Object)"enter getCallhomeBasicInfo");
        this.checkUserOperationAuthority("remoteMaintainence_queryRemoteMaintain_operateName", 2, "lego.sys.cloudservice.scan");
        CloudServiceBaseInfo csBaseInfo = this.getCloudServiceService().getCloudServiceBaseInfo();
        if (csBaseInfo == null) {
            csBaseInfo = new CloudServiceBaseInfo();
            csBaseInfo.setUseEnable(false);
            csBaseInfo.setLanguage(1);
        }
        return csBaseInfo;
    }

    @Override
    public List<CloudServiceNotifyEmail> getNotifyObjects() {
        log.trace((Object)"enter getNotifyObjects");
        this.checkUserOperationAuthority("remoteMaintainence_queryRemoteMaintain_operateName", 2, "lego.sys.cloudservice.scan");
        List cloudServiceNotifyEmailList = this.getCloudServiceService().getCloudServiceNotifyEmail();
        return cloudServiceNotifyEmailList;
    }

    @Override
    public Response modifyCallhomeBasicInfo(CloudServiceBaseInfo csBaseInfo) {
        this.checkUserOperationAuthority("remoteMaintainence_modifyRemoteMaintain_operateName", 3, "lego.lab.cloudservice.baseinfo.modify");
        if (!this.validateCloudServiceBaseInfo(csBaseInfo)) {
            log.info((Object)"Get wrong parameter when saveCallhomeBaseInfo", 653110169305088L);
            throw new LegoCheckedException(250L);
        }
        try {
            this.getCloudServiceService().modifyCloudServiceBaseInfo(csBaseInfo);
            this.writeSucOperationLog("remoteMaintainence_modifyRemoteMaintain_operateName", 3, "remoteMaintainConfig_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("remoteMaintainence_modifyRemoteMaintain_operateName", 3, "remoteMaintainConfig_objectName", e);
        }
        return Response.ok().build();
    }

    private boolean validateCloudServiceBaseInfo(CloudServiceBaseInfo csBaseInfo) {
        log.trace((Object)"enter validateCloudServiceBaseInfo");
        if (!LANGUAGE_BOUND.contains(csBaseInfo.getLanguage())) {
            return false;
        }
        String description = csBaseInfo.getDescription();
        return null == description || Validator.checkStringLength((String)description, (int)128);
    }

    private ICloudService getCloudServiceService() {
        log.trace((Object)"enter getCloudServiceService");
        ServiceContext context = ServiceContext.getInstance();
        return (ICloudService)context.lookup("cloudServiceApp/cloudService");
    }

    @Override
    public Response addNotifyObject(CloudServiceNotifyEmail cloudServiceNotifyEmail) {
        log.trace((Object)"enter addNotifyObject");
        this.checkUserOperationAuthority("remoteMaintainence_createNotificationObject_operateName", 3, "lego.lab.cloudservice.notify.add");
        if (!this.validateNotifyObj(cloudServiceNotifyEmail)) {
            throw new LegoCheckedException(250L);
        }
        try {
            ICloudService cloudServiceService = this.getCloudServiceService();
            cloudServiceService.addCloudServiceNotifyEmail(cloudServiceNotifyEmail.getEmailAddress(), cloudServiceNotifyEmail.getRemark());
            this.writeSucOperationLog("remoteMaintainence_createNotificationObject_operateName", 3, SecurityUtil.maskEmail((String)cloudServiceNotifyEmail.getEmailAddress()), null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("remoteMaintainence_createNotificationObject_operateName", 3, SecurityUtil.maskEmail((String)cloudServiceNotifyEmail.getEmailAddress()), e);
        }
        return Response.ok().build();
    }

    private boolean validateNotifyObj(CloudServiceNotifyEmail cloudServiceNotifyEmail) {
        log.trace((Object)"enter validateNotifyObj");
        if (!CommUtils.checkParam((String)cloudServiceNotifyEmail.getEmailAddress(), (int)1, (int)254) || !Validator.isEmail((String)cloudServiceNotifyEmail.getEmailAddress())) {
            return false;
        }
        return cloudServiceNotifyEmail.getRemark() == null || 0 == cloudServiceNotifyEmail.getRemark().length() || CommUtils.checkParam((String)cloudServiceNotifyEmail.getRemark(), (int)1, (int)255);
    }

    @Override
    public BatchOperationResult deleteNotifyObjects(Set<Long> ids) {
        this.checkUserOperationAuthority("remoteMaintainence_deleteNotificationObject_operateName", 2, "lego.lab.cloudservice.notify.del");
        ArrayList<BatchOperation> bathOprLst = new ArrayList<BatchOperation>();
        if (VerifyUtil.isEmpty(ids)) {
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<BatchOperation> errorList = new ArrayList<BatchOperation>();
        for (Long id : ids) {
            CloudServiceNotifyEmail cloudServiceNotifyEmail;
            BatchOperation tempBatch = new BatchOperation();
            tempBatch.setTargetId(id.longValue());
            try {
                cloudServiceNotifyEmail = this.getCloudServiceService().getCloudServiceNotifyEmail(id.longValue());
            }
            catch (LegoCheckedException e) {
                log.error((Object)"getCloudServiceNotifyEmail error!", (Throwable)e, e.getErrorCode());
                tempBatch.setErrorCode(e.getErrorCode());
                errorList.add(tempBatch);
                continue;
            }
            if (cloudServiceNotifyEmail == null) {
                tempBatch.setErrorCode(1073947394L);
                errorList.add(tempBatch);
                continue;
            }
            tempBatch.setTargetName(SecurityUtil.maskEmail((String)cloudServiceNotifyEmail.getEmailAddress()));
            bathOprLst.add(tempBatch);
        }
        BatchOperationResult batchOperationResult = new BatchOperationResult();
        try {
            batchOperationResult = this.getCloudServiceService().deleteNotifyObject(bathOprLst);
            this.dealBatchOperation(errorList, batchOperationResult);
        }
        catch (LegoCheckedException e) {
            long errorCode = e.getErrorCode();
            log.error((Object)"deleteNotifyObject error!", (Throwable)e, errorCode);
            this.dealBatchOperationForException(bathOprLst, errorList, batchOperationResult, errorCode);
            this.writeFailedOperationLog("remoteMaintainence_deleteNotificationObject_operateName", 2, "", (Exception)((Object)e));
        }
        catch (Exception e) {
            long errorCode = -1L;
            log.error((Object)("deleteNotifyObject error!" + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            this.dealBatchOperationForException(bathOprLst, errorList, batchOperationResult, -1L);
            this.writeFailedOperationLog("remoteMaintainence_deleteNotificationObject_operateName", 2, "", e);
        }
        this.batchOptLog(batchOperationResult, "remoteMaintainence_deleteNotificationObject_operateName", 2);
        return batchOperationResult;
    }

    private void dealBatchOperationForException(List<BatchOperation> bathOprLst, List<BatchOperation> errorList, BatchOperationResult batchOperationResult, long errorCode) {
        log.trace((Object)"enter dealBatchOperationForException");
        for (BatchOperation batchOperation : bathOprLst) {
            batchOperation.setErrorCode(errorCode);
        }
        errorList.addAll(bathOprLst);
        batchOperationResult.setResult(errorList);
        batchOperationResult.setFailCount(errorList.size());
        batchOperationResult.setTotalCount(errorList.size());
    }

    private void dealBatchOperation(List<BatchOperation> errorList, BatchOperationResult batchOperationResult) {
        log.trace((Object)"enter dealBatchOperation");
        List resultList = batchOperationResult.getResult();
        if (resultList == null) {
            batchOperationResult.setResult(errorList);
            batchOperationResult.setFailCount(errorList.size());
            batchOperationResult.setTotalCount(errorList.size());
        } else {
            resultList.addAll(errorList);
            batchOperationResult.setFailCount(batchOperationResult.getFailCount() + errorList.size());
            batchOperationResult.setTotalCount(batchOperationResult.getTotalCount() + errorList.size());
        }
    }

    @Override
    public Response saveBureauInfo(BureauInfo bureauInfo) {
        log.trace((Object)"enter saveBureauInfo");
        this.checkUserOperationAuthority("remoteMaintainence_modifyLocationInfo_operateName", 3, "lego.sys.bureauEdit");
        if (!CloudServiceRestServiceImpl.validateBureauInfo(bureauInfo)) {
            throw new LegoCheckedException(250L);
        }
        try {
            this.updateFormBureauInfo(bureauInfo);
            this.getbureauService().modifyBureauInfo(bureauInfo);
            this.writeSucOperationLog("remoteMaintainence_modifyLocationInfo_operateName", 3, "locationInfo_object_name", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("remoteMaintainence_modifyLocationInfo_operateName", 3, "locationInfo_object_name", e);
        }
        return Response.ok().build();
    }

    private static boolean validateBureauInfo(BureauInfo bureauInfo) {
        log.trace((Object)"enter validateBureauInfo");
        String stringCheck = "^[a-zA-Z_\u4e00-\u9fa5]{1}[\u4e00-\u9fa5\\w-]*$";
        CloudServiceRestServiceImpl.checkBureauName(bureauInfo);
        CloudServiceRestServiceImpl.checkClientName(bureauInfo, stringCheck);
        CloudServiceRestServiceImpl.checkLinkName(bureauInfo, stringCheck);
        CloudServiceRestServiceImpl.checkPhoneNum(bureauInfo);
        CloudServiceRestServiceImpl.checkSecondName(bureauInfo, stringCheck);
        CloudServiceRestServiceImpl.checkSecondEmail(bureauInfo);
        CloudServiceRestServiceImpl.checkLocation(bureauInfo);
        return true;
    }

    private static void checkBureauName(BureauInfo bureauInfo) {
        log.trace((Object)"enter checkBureauName");
        if (bureauInfo.getBureauName() != null && 0 != bureauInfo.getBureauName().length() && !Validator.checkStringLength((String)bureauInfo.getBureauName(), (int)32)) {
            throw new LegoCheckedException(250L);
        }
    }

    private static void checkClientName(BureauInfo bureauInfo, String stringCheck) {
        log.trace((Object)"enter checkClientName");
        if (Validator.stringisNull((String)bureauInfo.getClientName())) {
            throw new LegoCheckedException(250L);
        }
        if (bureauInfo.getClientName() != null && 0 != bureauInfo.getClientName().length()) {
            if (!Validator.checkStringLength((String)bureauInfo.getClientName(), (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.regExpCheck((String)bureauInfo.getClientName(), (String)stringCheck)) {
                throw new LegoCheckedException(250L);
            }
        }
    }

    private static void checkLinkName(BureauInfo bureauInfo, String stringCheck) {
        log.trace((Object)"enter checkLinkName");
        if (Validator.stringisNull((String)bureauInfo.getLinkman())) {
            throw new LegoCheckedException(250L);
        }
        if (bureauInfo.getLinkman() != null && 0 != bureauInfo.getLinkman().length()) {
            if (!Validator.checkStringLength((String)bureauInfo.getLinkman(), (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.regExpCheck((String)bureauInfo.getLinkman(), (String)stringCheck)) {
                throw new LegoCheckedException(250L);
            }
        }
    }

    private static void checkPhoneNum(BureauInfo bureauInfo) {
        log.trace((Object)"enter checkPhoneNum");
        if (Validator.stringisNull((String)bureauInfo.getPhone())) {
            throw new LegoCheckedException(250L);
        }
        if (!(bureauInfo.getPhone() == null || 0 == bureauInfo.getPhone().length() || CommUtils.checkParam((String)bureauInfo.getPhone(), (int)1, (int)32) && Validator.isPhoneInternation((String)bureauInfo.getPhone()))) {
            throw new LegoCheckedException(250L);
        }
        if (Validator.stringisNull((String)bureauInfo.getContactEmail())) {
            throw new LegoCheckedException(250L);
        }
        if (!(bureauInfo.getContactEmail() == null || 0 == bureauInfo.getContactEmail().length() || CommUtils.checkParam((String)bureauInfo.getContactEmail(), (int)1, (int)254) && Validator.isEmail((String)bureauInfo.getContactEmail()))) {
            throw new LegoCheckedException(250L);
        }
    }

    private static void checkSecondName(BureauInfo bureauInfo, String stringCheck) {
        log.trace((Object)"enter checkSecondName");
        if (bureauInfo.getSecendLinkman() != null && 0 != bureauInfo.getSecendLinkman().length()) {
            if (!Validator.checkStringLength((String)bureauInfo.getSecendLinkman(), (int)32)) {
                throw new LegoCheckedException(250L);
            }
            if (!Validator.regExpCheck((String)bureauInfo.getSecendLinkman(), (String)stringCheck)) {
                throw new LegoCheckedException(250L);
            }
        }
        if (!(bureauInfo.getSecendPhone() == null || 0 == bureauInfo.getSecendPhone().length() || Validator.checkStringLength((String)bureauInfo.getSecendPhone(), (int)32) && Validator.isPhoneInternation((String)bureauInfo.getSecendPhone()))) {
            throw new LegoCheckedException(250L);
        }
    }

    private static void checkSecondEmail(BureauInfo bureauInfo) {
        log.trace((Object)"enter checkSecondEmail");
        if (!(bureauInfo.getSecondContactEmail() == null || 0 == bureauInfo.getSecondContactEmail().length() || Validator.checkStringLength((String)bureauInfo.getSecondContactEmail(), (int)254) && Validator.isEmail((String)bureauInfo.getSecondContactEmail()))) {
            throw new LegoCheckedException(250L);
        }
        if (bureauInfo.getBuGuarder() != null && 0 != bureauInfo.getBuGuarder().length() && !Validator.checkStringLength((String)bureauInfo.getBuGuarder(), (int)32)) {
            throw new LegoCheckedException(250L);
        }
        if (!(bureauInfo.getBuGuarderPhone() == null || 0 == bureauInfo.getBuGuarderPhone().length() || Validator.checkStringLength((String)bureauInfo.getBuGuarderPhone(), (int)32) && Validator.isPhoneInternation((String)bureauInfo.getBuGuarderPhone()))) {
            throw new LegoCheckedException(250L);
        }
    }

    private static void checkLocation(BureauInfo bureauInfo) {
        log.trace((Object)"enter checkLocation");
        if (Validator.stringisNull((String)bureauInfo.getLocation())) {
            throw new LegoCheckedException(250L);
        }
        if (bureauInfo.getLocation() != null && 0 != bureauInfo.getLocation().length() && !Validator.checkStringLength((String)bureauInfo.getLocation(), (int)128)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void updateFormBureauInfo(BureauInfo bureauInfo) {
        log.trace((Object)"enter updateFormBureauInfo");
        if (VerifyUtil.isEmpty((String)bureauInfo.getClientId())) {
            String clientId = UUIDGenerator.getUUID();
            bureauInfo.setClientId(clientId);
        }
        if (VerifyUtil.isEmpty((String)bureauInfo.getDeviceSN())) {
            String deviceSN = UUIDGenerator.getUUID();
            bureauInfo.setDeviceSN(deviceSN);
        }
        if (VerifyUtil.isEmpty((String)bureauInfo.getDeviceType())) {
            this.setNewDeviceType(bureauInfo);
        }
        if (VerifyUtil.isEmpty((String)bureauInfo.getProductVersion())) {
            this.setNewPeoductVersion(bureauInfo);
        }
    }

    private void setNewPeoductVersion(BureauInfo bureauInfo) {
        log.trace((Object)"enter setNewPeoductVersion");
        String productVersion = PRODUCT_VERSION_KEY_APM;
        bureauInfo.setProductVersion(productVersion);
    }

    private void setNewDeviceType(BureauInfo bureauInfo) {
        log.trace((Object)"enter setNewDeviceType");
        String deviceType = DEVICE_TYPE_KEY_LEGO;
        if (VerifyUtil.isEmpty((String)deviceType) || DEVICE_TYPE_KEY_APM.equalsIgnoreCase(deviceType)) {
            deviceType = this.getText(DEVICE_TYPE_KEY_IC);
        }
        if (VerifyUtil.isEmpty((String)deviceType) || DEVICE_TYPE_KEY_IC.equalsIgnoreCase(deviceType)) {
            deviceType = this.getText(DEVICE_TYPE_KEY_LEGO);
        }
        bureauInfo.setDeviceType(deviceType);
    }

    private IBureauService getbureauService() {
        log.trace((Object)"enter getbureauService");
        ServiceContext context = ServiceContext.getInstance();
        return (IBureauService)context.lookup("cloudServiceApp/bureauService");
    }

    @Override
    public Response modifyNotifyObject(Long id, CloudServiceNotifyEmail notifyObject) {
        block6: {
            this.checkUserOperationAuthority("remoteMaintainence_modifyNotificationObject_operateName", 3, "lego.lab.cloudservice.baseinfo.modify");
            CommUtils.checkParamEmpty((Object[])new Object[]{notifyObject});
            notifyObject.setId(id.longValue());
            if (id == -1L || !this.validateNotifyObj(notifyObject)) {
                throw new LegoCheckedException(250L);
            }
            try {
                this.getCloudServiceService().getCloudServiceNotifyEmail(notifyObject.getId());
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1571L) break block6;
                log.error((Object)("notifyObject:" + notifyObject.getId() + "not exist!"), (Throwable)e, e.getErrorCode());
                throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
            }
        }
        CloudServiceNotifyEmail oldNotifyObject = null;
        try {
            oldNotifyObject = this.getCloudServiceService().getCloudServiceNotifyEmail(id.longValue());
            this.getCloudServiceService().modifyCloudServiceNotifyEmail(notifyObject.getId(), notifyObject.getEmailAddress(), notifyObject.getRemark());
            this.writeSucOperationLog("remoteMaintainence_modifyNotificationObject_operateName", 3, SecurityUtil.maskEmail((String)notifyObject.getEmailAddress()), "remoteMaintainence_modifyNotificationObject_operateDetail", new String[]{SecurityUtil.maskEmail((String)notifyObject.getEmailAddress()), oldNotifyObject.getRemark(), SecurityUtil.maskEmail((String)notifyObject.getEmailAddress()), notifyObject.getRemark()});
        }
        catch (Exception e) {
            if (oldNotifyObject != null) {
                this.writeFailedOperationLog("remoteMaintainence_modifyNotificationObject_operateName", 3, SecurityUtil.maskEmail((String)notifyObject.getEmailAddress()), e);
            }
            this.writeFailedOperationLog("remoteMaintainence_modifyNotificationObject_operateName", 3, String.valueOf(id), e);
        }
        return Response.ok().build();
    }

    @Override
    public BureauInfo queryBureauInfo() {
        log.trace((Object)"enter queryBureauInfo");
        this.checkUserOperationAuthority("remoteMaintainence_queryLocationInfo_operateName", 2, "lego.sys.bureau.scan");
        BureauInfo bureauInfo = this.getbureauService().getBureauInfo();
        return bureauInfo;
    }
}

