/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.rest.service.framework.email.service;

import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.drm.rest.service.base.AbstractRestService;
import com.huawei.ism.drm.rest.service.framework.email.model.RemoteNotifyEmailServerVo;
import com.huawei.ism.drm.rest.service.framework.email.service.IEmailRestService;
import com.huawei.ism.drm.web.annotation.Logging;
import com.huawei.ism.drm.web.annotation.Permission;
import com.huawei.ism.drm.web.validator.Validator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.Ipv4AddressUtil;
import com.huawei.lego.core.sdk.util.Ipv6AddressUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyServer;
import com.huawei.lego.nem.fault.sdk.service.IRemoteNotifyServerService;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;

public class EmailRestServiceImpl
extends AbstractRestService
implements IEmailRestService {
    private static Log LOGGER = LogFactory.getInstance(EmailRestServiceImpl.class);

    @Override
    public Response modifyEmailServer(RemoteNotifyEmailServerVo vo) {
        LOGGER.trace((Object)"Enter modifyEmailServer.");
        this.checkUserOperationAuthority("notificationServer_setMailServer_operateName", 3, "lego.sys.serverEdit");
        VerifyUtil.checkObject((Object)((Object)vo));
        this.initRemoteNotifyEmailServerVo(vo);
        IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)this.getBundleService("notify", "remoteNotifyServerService");
        this.checkedNotifyServerPoParam(vo);
        RemoteNotifyServer remoteNotifyServerPO = remoteNotifyServerService.getRemoteNotifyServer();
        if (this.smtpServiceIpChanged(vo, remoteNotifyServerPO)) {
            if (!vo.isValidateEnable()) {
                LOGGER.error((Object)"Need identity authentication.");
                throw new LegoCheckedException(1073947393L);
            }
            if (VerifyUtil.isEmpty((String)vo.getUserName()) || VerifyUtil.isEmpty((String)vo.getPassword())) {
                LOGGER.error((Object)"Input username or passwd is illegal.");
                throw new LegoCheckedException(1073947393L);
            }
        } else {
            this.resetPasswd(vo, remoteNotifyServerPO);
        }
        try {
            remoteNotifyServerService.modifyEmailServer(vo.remoteNotifyServer());
            this.writeSucOperationLog("notificationServer_setMailServer_operateName", 3, "sysmailServer_objectName", null, null);
        }
        catch (Exception e) {
            this.writeFailedOperationLog("notificationServer_setMailServer_operateName", 3, "sysmailServer_objectName", e);
        }
        return Response.ok().build();
    }

    private boolean smtpServiceIpChanged(RemoteNotifyEmailServerVo vo, RemoteNotifyServer serverPo) {
        return !Objects.equals(vo.getServer(), serverPo.getServer()) || vo.isProxyEnable() && !Objects.equals(vo.getProxyServer(), serverPo.getProxyServer());
    }

    private void resetPasswd(RemoteNotifyEmailServerVo vo, RemoteNotifyServer serverPo) {
        if (!VerifyUtil.isEmpty((String)vo.getPassword())) {
            return;
        }
        if (vo.isValidateEnable() && VerifyUtil.isEmpty((String)serverPo.getPassword())) {
            throw new LegoCheckedException(250L);
        }
        vo.setPassword(serverPo.getPassword());
    }

    private void checkedNotifyServerPoParam(RemoteNotifyEmailServerVo vo) {
        LOGGER.trace((Object)"Enter checkedNotifyServerPoParam.");
        Integer protocol = vo.getProtocol();
        this.checkParamValid(vo, protocol);
        if (protocol < 0 || protocol > 2) {
            throw new LegoCheckedException(250L);
        }
        this.validateSecurityProtocol(vo, protocol);
        if (!(Validator.stringisNull((String)vo.getTestEmail()) || Validator.isEmail((String)vo.getTestEmail()) && Validator.checkStringLength((String)vo.getTestEmail(), (int)254))) {
            throw new LegoCheckedException(250L);
        }
        this.checkUserName(vo, 32);
        this.checkPasswordLength(vo);
        this.checkProxyServer(vo);
    }

    private void validateSecurityProtocol(RemoteNotifyEmailServerVo vo, Integer protocol) {
        LOGGER.trace((Object)"Enter validateSecurityProtocol.");
        if (protocol == 1) {
            if (!Validator.isNum((String)vo.getSslSmtpPort())) {
                throw new LegoCheckedException(250L);
            }
            Integer sslSmtpPort = NumberUtil.convertToInteger((Object)vo.getSslSmtpPort());
            int i = 65535;
            if (sslSmtpPort < 1 || sslSmtpPort > 65535) {
                throw new LegoCheckedException(250L);
            }
            vo.setIsSSLEnable(true);
            vo.setIsTLSEnable(false);
        } else if (protocol == 0) {
            vo.setIsSSLEnable(false);
            vo.setIsTLSEnable(false);
        } else {
            vo.setIsSSLEnable(false);
            vo.setIsTLSEnable(true);
        }
    }

    private void checkProxyServer(RemoteNotifyEmailServerVo vo) {
        LOGGER.trace((Object)"Enter checkProxyServer.");
        String proxyServer = vo.getProxyServer();
        String proxyPort = vo.getProxyPort();
        if (vo.isProxyEnable() && (VerifyUtil.isEmpty((String)proxyServer) || !Validator.isProxyIp((String)proxyServer) || VerifyUtil.isEmpty((String)proxyPort) || !Validator.isNum((String)proxyPort) || !Validator.isPort((int)NumberUtil.convertToInteger((Object)proxyPort)))) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkPasswordLength(RemoteNotifyEmailServerVo vo) {
        LOGGER.debug((Object)"Enter checkPasswordLength.");
        String password = vo.getPassword();
        if (!vo.isValidateEnable()) {
            return;
        }
        if (VerifyUtil.isEmpty((String)password)) {
            throw new LegoCheckedException(250L);
        }
        if (!Validator.checkStringLength((String)password, (int)32)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void checkUserName(RemoteNotifyEmailServerVo vo, int length) {
        LOGGER.trace((Object)"Enter checkUserName.");
        String userName = vo.getUserName();
        if (vo.isValidateEnable()) {
            if (Validator.stringisNull((String)userName) || !Validator.checkStringLength((String)userName, (int)length)) {
                throw new LegoCheckedException(250L);
            }
            if (userName.startsWith(" ") || userName.endsWith(" ") || !Validator.isDefaultName((String)userName)) {
                throw new LegoCheckedException(250L);
            }
        }
    }

    private void checkParamValid(RemoteNotifyEmailServerVo vo, Integer protocol) {
        LOGGER.trace((Object)"Enter checkParamValid.");
        if (VerifyUtil.isEmpty((Object)((Object)vo))) {
            throw new LegoCheckedException(1073947393L);
        }
        this.validateServer(vo);
        if (!Validator.isPort((int)NumberUtil.convertToInteger((Object)vo.getPort())) || !Validator.checkStringLength((String)vo.getEmailFrom(), (int)254) || !Validator.isEmail((String)vo.getEmailFrom()) || VerifyUtil.isEmpty((Object)protocol)) {
            throw new LegoCheckedException(250L);
        }
    }

    private void validateServer(RemoteNotifyEmailServerVo vo) {
        LOGGER.trace((Object)"Enter validateServer.");
        if (Validator.stringisNull((String)vo.getServer()) || !Validator.checkStringLength((String)vo.getServer(), (int)32)) {
            throw new LegoCheckedException(250L);
        }
        if (!Ipv4AddressUtil.isValidIPv4((String)vo.getServer()) && !Ipv6AddressUtil.isValidIPv6((String)vo.getServer()) || !Validator.isDefaultName((String)vo.getServer()) || !Validator.isNum((String)vo.getPort())) {
            throw new LegoCheckedException(250L);
        }
    }

    @Override
    public RemoteNotifyEmailServerVo queryEmailServer() {
        LOGGER.trace((Object)"Enter queryEmailServer.");
        this.checkUserOperationAuthority("notificationServer_queryNotifyServer_operateName", 2, "lego.sys.server.scan");
        IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)this.getBundleService("notify", "remoteNotifyServerService");
        RemoteNotifyServer remoteNotifyServerPO = remoteNotifyServerService.getRemoteNotifyServer();
        if (remoteNotifyServerPO != null) {
            remoteNotifyServerPO.setPassword("");
        } else {
            remoteNotifyServerPO = new RemoteNotifyServer();
        }
        String serverIp = remoteNotifyServerPO.getServer();
        if (Ipv6AddressUtil.isSavedIpv6((String)serverIp)) {
            serverIp = serverIp.substring(1, serverIp.length() - 1);
            remoteNotifyServerPO.setServer(serverIp);
        }
        return new RemoteNotifyEmailServerVo(remoteNotifyServerPO);
    }

    @Override
    @Permission(name={"lego.sys.serverEdit"})
    @Logging(name="notificationServer_sendTestMail_operateName", object="$1?.testEmail", mask=true)
    public Response testEmailServer(RemoteNotifyEmailServerVo vo) {
        int errorCode;
        VerifyUtil.checkObject((Object)((Object)vo));
        this.initRemoteNotifyEmailServerVo(vo);
        try {
            RemoteNotifyServer remoteNotifyServer;
            this.checkedNotifyServerPoParam(vo);
            IRemoteNotifyServerService remoteNotifyServerService = (IRemoteNotifyServerService)this.getBundleService("notify", "remoteNotifyServerService");
            if (vo.isValidateEnable() && (null == vo.getPassword() || 0 == vo.getPassword().length()) && null != (remoteNotifyServer = remoteNotifyServerService.getRemoteNotifyServer())) {
                vo.setPassword(remoteNotifyServer.getPassword());
            }
            if (Ipv6AddressUtil.isIPv6Address((String)vo.getServer())) {
                vo.setServer(Ipv6AddressUtil.convertIpv6((String)vo.getServer()));
            }
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            SimpleTimeLimiter simpleTimeLimiter = SimpleTimeLimiter.create((ExecutorService)executor);
            IRemoteNotifyServerService remoteNotifyServerServiceProxy = (IRemoteNotifyServerService)simpleTimeLimiter.newProxy((Object)remoteNotifyServerService, IRemoteNotifyServerService.class, 4L, TimeUnit.SECONDS);
            try {
                errorCode = remoteNotifyServerServiceProxy.testSendEmail(vo.remoteNotifyServer());
            }
            catch (Exception e) {
                LOGGER.error((Object)"Test mail server timeout,error: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                throw new LegoCheckedException(EmailRestServiceImpl.switchErrorCode(-1), "");
            }
        }
        catch (LegoCheckedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LegoCheckedException(EmailRestServiceImpl.switchErrorCode(1), "", (Throwable)e);
        }
        if (errorCode == -1) {
            try {
                Thread.sleep(4000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)"Test mail server timeout interrupted,error: %s:{}", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            }
            throw new LegoCheckedException(EmailRestServiceImpl.switchErrorCode(errorCode), "");
        }
        if (errorCode != 0) {
            throw new LegoCheckedException(EmailRestServiceImpl.switchErrorCode(errorCode), "");
        }
        return Response.ok().build();
    }

    private void initRemoteNotifyEmailServerVo(RemoteNotifyEmailServerVo vo) {
        LOGGER.trace((Object)"Enter initRemoteNotifyEmailServerVo.");
        vo.setProxyEnable(vo.isIsProxyEnable());
        vo.setValidateEnable(vo.isIsValidateEnable());
    }

    private static long switchErrorCode(int errorCode) {
        long errCode;
        LOGGER.trace((Object)"Enter switchErrorCode.");
        switch (errorCode) {
            case 0: {
                errCode = 0L;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: {
                errCode = 1073947427L;
                break;
            }
            case 5: {
                errCode = 1073947407L;
                break;
            }
            case 6: {
                errCode = 1073947410L;
                break;
            }
            case 8: {
                errCode = 1073947408L;
                break;
            }
            case 12: {
                errCode = 1073947406L;
                break;
            }
            default: {
                errCode = 1073947409L;
            }
        }
        return errCode;
    }
}

